/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.DataType;

public interface ObjectVariation
extends EnumCode {
    @Nonnull
    @CheckReturnValue
    public Optional<DataType> getDataType();

    @Nonnull
    @CheckReturnValue
    public Class<? extends ObjectInstance> getObjectClass();

    @Nonnull
    @CheckReturnValue
    public ObjectGroup getObjectGroup();

    @Nonnull
    @CheckReturnValue
    default public Optional<PointType> getPointType() {
        return this.getObjectGroup().getPointType();
    }

    @Nonnull
    @CheckReturnValue
    public String getTitle();

    @CheckReturnValue
    default public boolean isAny() {
        return this.getCode() == 0;
    }

    @CheckReturnValue
    default public boolean isPacked() {
        return false;
    }

    @Nonnull
    @CheckReturnValue
    default public ObjectInstance newObjectInstance() {
        try {
            return this.getObjectClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new InternalError(exception);
        }
    }
}

