/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Content;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputSupport;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputSupport;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.DoubleBitInputSupport;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.SingleBitInputSupport;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputSupport;
import org.rvpf.pap.dnp3.object.groupCategory.counters.CounterSupport;

public enum PointType {
    ANALOG_INPUT("Analog Input", new AnalogInputSupport()),
    ANALOG_OUTPUT("Analog Output", new AnalogOutputSupport()),
    SINGLE_BIT_INPUT("Single-bit Input", new SingleBitInputSupport()),
    DOUBLE_BIT_INPUT("Single-bit Input", new DoubleBitInputSupport()),
    BINARY_OUTPUT("Binary Output", new BinaryOutputSupport()),
    COUNTER("Counter", new CounterSupport());

    private final Support _support;
    private final String _title;

    private PointType(String title, Support pointTypeSupport) {
        this._title = title;
        this._support = pointTypeSupport;
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectInstance newObjectInstance(@Nonnull ObjectVariation objectVariation) {
        ObjectInstance objectInstance;
        try {
            objectInstance = objectVariation.getObjectClass().newInstance();
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
        return objectInstance;
    }

    @Nonnull
    @CheckReturnValue
    public Support getSupport() {
        return this._support;
    }

    @Nonnull
    @CheckReturnValue
    public String getTitle() {
        return this._title;
    }

    public static interface Support {
        @Nonnull
        @CheckReturnValue
        public Optional<DataType> getDataType(@Nonnull Content var1);

        @Nonnull
        @CheckReturnValue
        public ObjectVariation getInputVariation();

        @Nonnull
        @CheckReturnValue
        public Optional<ObjectVariation> getInputVariation(@Nonnull DataType var1);

        @Nonnull
        @CheckReturnValue
        public Optional<ObjectVariation> getOutputVariation(@Nonnull DataType var1);

        @Nonnull
        @CheckReturnValue
        public PointType getPointType();

        @CheckReturnValue
        public boolean isReadOnly();
    }
}

