/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.content;

import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;

public enum InternalIndication implements EnumCode
{
    BROADCAST("Broadcast Message Received"),
    CLASS_1_EVENTS("Additional Class 1 Event Data Is Available"),
    CLASS_2_EVENTS("Additional Class 2 Event Data Is Available"),
    CLASS_3_EVENTS("Additional Class 3 Event Data Is Available"),
    NEED_TIME("Time Synchronization Required"),
    LOCAL_CONTROL("Some Output Points Are In Local Mode"),
    DEVICE_TROUBLE("Device Trouble"),
    DEVICE_RESTART("Device Restart"),
    NO_FUNC_CODE_SUPPORT("Function Code Not Implemented"),
    OBJECT_UNKNOWN("Object Unknown"),
    PARAMETER_ERROR("Parameter Error"),
    EVENT_BUFFER_OVERFLOW("Event Buffer Overflow"),
    ALREADY_EXECUTING("Operation Is already Executing"),
    CONFIG_CORRUPT("Configuration Corrupt"),
    RESERVED_1("Reserved Bit"),
    RESERVED_2("Reserved Bit");

    private static final Map<Integer, InternalIndication> _CODE_MAP;
    private final String _title;

    private InternalIndication(String title) {
        this._title = title;
    }

    @CheckReturnValue
    public static int getSize() {
        return _CODE_MAP.size();
    }

    @Nonnull
    @CheckReturnValue
    public static InternalIndication instance(int code) throws AssertionError {
        return (InternalIndication)Require.notNull((Object)_CODE_MAP.get(code), (Object)String.valueOf(code));
    }

    @Override
    public int getCode() {
        return this.ordinal();
    }

    @CheckReturnValue
    public int getMask() {
        return 1 << this.ordinal();
    }

    @Nonnull
    @CheckReturnValue
    public String getTitle() {
        return this._title;
    }

    static {
        _CODE_MAP = EnumCode.MapFactory.codeMap((Enum[])InternalIndication.values());
    }
}

