/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogInputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V0;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V1;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V2;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V3;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V4;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V5;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V6;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V7;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G32V8;

public enum AnalogInputEventVariation implements ObjectVariation
{
    ANY(0, "Any", G32V0.class, Optional.empty()),
    INTEGER_WITHOUT_TIME(1, "32-bit without time", G32V1.class, Optional.of(DataType.INT32)),
    SHORT_WITHOUT_TIME(2, "16-bit without time", G32V2.class, Optional.of(DataType.INT16)),
    INTEGER_WITH_TIME(3, "32-bit with time", G32V3.class, Optional.of(DataType.INT32)),
    SHORT_WITH_TIME(4, "16-bit with time", G32V4.class, Optional.of(DataType.INT16)),
    FLOAT_WITHOUT_TIME(5, "Single-precision without time", G32V5.class, Optional.of(DataType.FLOAT16)),
    DOUBLE_WITHOUT_TIME(6, "Double-precision without time", G32V6.class, Optional.of(DataType.FLOAT32)),
    FLOAT_WITH_TIME(7, "Single-precision with time", G32V7.class, Optional.of(DataType.FLOAT16)),
    DOUBLE_WITH_TIME(8, "Double-precision with time", G32V8.class, Optional.of(DataType.FLOAT32));

    private static final Map<Integer, AnalogInputEventVariation> _VARIATION_MAP;
    private final int _code;
    private final Optional<DataType> _dataType;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private AnalogInputEventVariation(@Nonnull int code, @Nonnull String title, Class<? extends ObjectInstance> objectClass, Optional<DataType> dataType) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public static AnalogInputEventVariation instance(int variationCode) {
        return (AnalogInputEventVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return this._dataType;
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return AnalogInputsGroup.ANALOG_INPUT_EVENT;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])AnalogInputEventVariation.values());
    }
}

