/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogInputs;

import java.util.Optional;
import org.rvpf.base.Content;
import org.rvpf.content.DoubleContent;
import org.rvpf.content.FloatContent;
import org.rvpf.content.IntegerContent;
import org.rvpf.content.LongContent;
import org.rvpf.content.ShortContent;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputVariation;

public final class AnalogInputSupport
implements PointType.Support {
    @Override
    public Optional<DataType> getDataType(Content content) {
        DataType dataType = content instanceof ShortContent ? DataType.INT16 : (content instanceof IntegerContent ? DataType.INT32 : (content instanceof FloatContent ? DataType.FLOAT16 : (content instanceof DoubleContent ? DataType.FLOAT32 : (content instanceof LongContent ? DataType.INT32 : null))));
        return Optional.ofNullable(dataType);
    }

    @Override
    public ObjectVariation getInputVariation() {
        return AnalogInputVariation.ANY;
    }

    @Override
    public Optional<ObjectVariation> getInputVariation(DataType dataType) {
        switch (dataType) {
            case FLOAT16: {
                return Optional.of(AnalogInputVariation.FLOAT_WITH_FLAG);
            }
            case FLOAT32: {
                return Optional.of(AnalogInputVariation.DOUBLE_WITH_FLAG);
            }
            case INT16: {
                return Optional.of(AnalogInputVariation.SHORT_WITH_FLAG);
            }
            case INT32: {
                return Optional.of(AnalogInputVariation.INTEGER_WITH_FLAG);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<ObjectVariation> getOutputVariation(DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PointType getPointType() {
        return PointType.ANALOG_INPUT;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

