/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogInputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V0;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V1;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V2;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V3;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V4;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V5;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G30V6;

public enum AnalogInputVariation implements ObjectVariation
{
    ANY(0, "Any", G30V0.class, Optional.empty()),
    INTEGER_WITH_FLAG(1, "32-bit with flag", G30V1.class, Optional.of(DataType.INT32)),
    SHORT_WITH_FLAG(2, "16-bit with flag", G30V2.class, Optional.of(DataType.INT16)),
    INTEGER_WITHOUT_FLAG(3, "32-bit without flag", G30V3.class, Optional.of(DataType.INT32)),
    SHORT_WITHOUT_FLAG(4, "16-bit without flag", G30V4.class, Optional.of(DataType.INT16)),
    FLOAT_WITH_FLAG(5, "Single-precision with flag", G30V5.class, Optional.of(DataType.FLOAT16)),
    DOUBLE_WITH_FLAG(6, "Double-precision with flag", G30V6.class, Optional.of(DataType.FLOAT32));

    private static final Map<Integer, AnalogInputVariation> _VARIATION_MAP;
    private final int _code;
    private final Optional<DataType> _dataType;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private AnalogInputVariation(@Nonnull int code, @Nonnull String title, Class<? extends ObjectInstance> objectClass, Optional<DataType> dataType) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public static AnalogInputVariation instance(int variationCode) {
        return (AnalogInputVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return this._dataType;
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return AnalogInputsGroup.ANALOG_INPUT;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])AnalogInputVariation.values());
    }
}

