/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogInputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputReportingDeadbandVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.FrozenAnalogInputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.FrozenAnalogInputVariation;

public enum AnalogInputsGroup implements ObjectGroup
{
    ANALOG_INPUT(30, "Analog Input", AnalogInputVariation.class),
    FROZEN_ANALOG_INPUT(31, "Frozen Analog Input", FrozenAnalogInputVariation.class),
    ANALOG_INPUT_EVENT(32, "Analog Input Event", AnalogInputEventVariation.class),
    FROZEN_ANALOG_INPUT_EVENT(33, "Frozen Analog Input Event", FrozenAnalogInputEventVariation.class),
    ANALOG_INPUT_REPORTING_DEADBAND(34, "Analog Input Reporting Deadband", AnalogInputReportingDeadbandVariation.class);

    private static final Map<Integer, AnalogInputsGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final String _title;

    private AnalogInputsGroup(@Nonnull int code, String title, Class<? extends ObjectVariation> objectVariationClass) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
    }

    @Nonnull
    @CheckReturnValue
    public static AnalogInputsGroup instance(int groupCode) {
        return (AnalogInputsGroup)Require.notNull((Object)_GROUP_MAP.get(groupCode));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.ANALOG_INPUTS;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public Optional<PointType> getPointType() {
        return Optional.of(PointType.ANALOG_INPUT);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])AnalogInputsGroup.values());
    }
}

