/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.analogInputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V0;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V1;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V2;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V3;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V4;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V5;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V6;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V7;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.G31V8;

public enum FrozenAnalogInputVariation implements ObjectVariation
{
    ANY(0, "Any", G31V0.class, Optional.empty()),
    INTEGER_WITH_FLAG(1, "32-bit with flag", G31V1.class, Optional.of(DataType.INT32)),
    SHORT_WITH_FLAG(2, "16-bit with flag", G31V2.class, Optional.of(DataType.INT16)),
    INTEGER_WITH_TIME(3, "32-bit with time", G31V3.class, Optional.of(DataType.INT32)),
    SHORT_WITH_TIME(4, "16-bit with time", G31V4.class, Optional.of(DataType.INT16)),
    INTEGER_WITHOUT_FLAG(5, "32-bit without flag", G31V5.class, Optional.of(DataType.INT32)),
    SHORT_WITHOUT_FLAG(6, "16-bit without flag", G31V6.class, Optional.of(DataType.INT16)),
    FLOAT_WITH_FLAG(7, "Single-precision with flag", G31V7.class, Optional.of(DataType.FLOAT16)),
    DOUBLE_WITH_FLAG(8, "Double-precision with flag", G31V8.class, Optional.of(DataType.FLOAT32));

    private static final Map<Integer, FrozenAnalogInputVariation> _VARIATION_MAP;
    private final int _code;
    private final Optional<DataType> _dataType;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private FrozenAnalogInputVariation(@Nonnull int code, @Nonnull String title, Class<? extends ObjectInstance> objectClass, Optional<DataType> dataType) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public static FrozenAnalogInputVariation instance(int variationCode) {
        return (FrozenAnalogInputVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return this._dataType;
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return AnalogInputsGroup.FROZEN_ANALOG_INPUT;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])FrozenAnalogInputVariation.values());
    }
}

