/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryInputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.BinaryInputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.BinaryInputVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.DoubleBitBinaryInputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.DoubleBitBinaryInputVariation;

public enum BinaryInputsGroup implements ObjectGroup
{
    BINARY_INPUT(1, "Binary Input", BinaryInputVariation.class, PointType.SINGLE_BIT_INPUT),
    BINARY_INPUT_EVENT(2, "Binary Input Event", BinaryInputEventVariation.class, PointType.SINGLE_BIT_INPUT),
    DOUBLE_BIT_BINARY_INPUT(3, "Double-bit Binary Input", DoubleBitBinaryInputVariation.class, PointType.DOUBLE_BIT_INPUT),
    DOUBLE_BIT_BINARY_INPUT_EVENT(4, "Double-bit Binary Input Event", DoubleBitBinaryInputEventVariation.class, PointType.DOUBLE_BIT_INPUT);

    private static final Map<Integer, BinaryInputsGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final PointType _pointType;
    private final String _title;

    private BinaryInputsGroup(@Nonnull int code, @Nonnull String title, Class<? extends ObjectVariation> objectVariationClass, PointType pointType) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
        this._pointType = pointType;
    }

    @Nonnull
    @CheckReturnValue
    public static BinaryInputsGroup instance(int groupCode) {
        return (BinaryInputsGroup)Require.notNull((Object)_GROUP_MAP.get(groupCode));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.BINARY_INPUTS;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public Optional<PointType> getPointType() {
        return Optional.of(this._pointType);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])BinaryInputsGroup.values());
    }
}

