/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryInputs;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.DoubleBitBinaryInputVariation;

public final class G3V1
extends ObjectInstance.Abstract
implements ObjectInstance.Packed {
    private byte[] _states;
    private int _valueCount;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        buffer.put(this.getStates());
    }

    @Override
    public int get(int position) {
        return G3V1.getBits(this._states, position, 2, 3);
    }

    @Override
    public int getObjectLength() {
        return this.getStates().length;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return DoubleBitBinaryInputVariation.PACKED_FORMAT;
    }

    @Nonnull
    @CheckReturnValue
    public byte[] getStates() {
        return (byte[])Require.notNull((Object)this._states);
    }

    @Override
    public int getValueCount() {
        return this._valueCount;
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this._states = new byte[this.byteCount(2)];
        buffer.get(this._states);
    }

    @Override
    public void put(int position, int value) {
        this._states = G3V1.putBits(value, this._states, position, 2, 3);
    }

    @Override
    public void setValueCount(int count) {
        this._valueCount = count;
    }
}

