/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryInputs;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.DoubleBitBinaryInputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.G4V1;

public final class G4V3
extends G4V1 {
    private short _relativeTime;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        super.dumpToBuffer(buffer);
        buffer.putShort(this._relativeTime);
    }

    @Override
    public int getObjectLength() {
        return super.getObjectLength() + 2;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return DoubleBitBinaryInputEventVariation.WITH_RELATIVE_TIME;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime getRelativeTime() {
        return ElapsedTime.fromMillis((long)(this._relativeTime & 0xFFFF));
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        super.loadFromBuffer(buffer);
        this._relativeTime = buffer.getShort();
    }

    public void setRelativeTime(@Nonnull ElapsedTime relativeTime) {
        this._relativeTime = (short)relativeTime.toMillis();
    }
}

