/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G11V0;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G11V1;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G11V2;

public enum BinaryOutputEventVariation implements ObjectVariation
{
    ANY(0, "Any", G11V0.class),
    WITHOUT_TIME(1, "Without time", G11V1.class),
    WITH_TIME(2, "With time", G11V2.class);

    private static final Map<Integer, BinaryOutputEventVariation> _VARIATION_MAP;
    private final int _code;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private BinaryOutputEventVariation(@Nonnull int code, String title, Class<? extends ObjectInstance> objectClass) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
    }

    @Nonnull
    @CheckReturnValue
    public static BinaryOutputEventVariation instance(int variationCode) {
        return (BinaryOutputEventVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return Optional.empty();
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return BinaryOutputsGroup.BINARY_OUTPUT_EVENT;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])BinaryOutputEventVariation.values());
    }
}

