/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G10V0;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G10V1;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G10V2;

public enum BinaryOutputVariation implements ObjectVariation
{
    ANY(0, "Any", G10V0.class),
    PACKED_FORMAT(1, "Packed format", G10V1.class),
    WITH_FLAGS(2, "With flags", G10V2.class);

    private static final Map<Integer, BinaryOutputVariation> _VARIATION_MAP;
    private final int _code;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private BinaryOutputVariation(@Nonnull int code, String title, Class<? extends ObjectInstance> objectClass) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
    }

    @Nonnull
    @CheckReturnValue
    public static BinaryOutputVariation instance(int variationCode) {
        return (BinaryOutputVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return Optional.empty();
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return BinaryOutputsGroup.BINARY_OUTPUT;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public boolean isPacked() {
        return this == PACKED_FORMAT;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])BinaryOutputVariation.values());
    }
}

