/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs;

import java.nio.ByteBuffer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.G11V1;

public final class G11V2
extends G11V1 {
    private long _absoluteTime;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        super.dumpToBuffer(buffer);
        G11V2.putTimeToBuffer(this._absoluteTime, buffer);
    }

    @Nonnull
    @CheckReturnValue
    public DateTime getAbsoluteTime() {
        return DateTime.fromMillis((long)this._absoluteTime);
    }

    @Override
    public int getObjectLength() {
        return super.getObjectLength() + 6;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return BinaryOutputEventVariation.WITH_TIME;
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        super.loadFromBuffer(buffer);
        this._absoluteTime = G11V2.getTimeFromBuffer(buffer);
    }

    public void setAbsoluteTime(@Nonnull DateTime absoluteTime) {
        this._absoluteTime = absoluteTime.toMillis();
    }
}

