/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.classes;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.classes.ClassesGroup;
import org.rvpf.pap.dnp3.object.groupCategory.classes.G60V0;
import org.rvpf.pap.dnp3.object.groupCategory.classes.G60V1;
import org.rvpf.pap.dnp3.object.groupCategory.classes.G60V2;
import org.rvpf.pap.dnp3.object.groupCategory.classes.G60V3;
import org.rvpf.pap.dnp3.object.groupCategory.classes.G60V4;

public enum ClassObjectsVariation implements ObjectVariation
{
    ANY(0, "Any", G60V0.class),
    CLASS_0_DATA(1, "Class 0 data", G60V1.class),
    CLASS_1_DATA(2, "Class 1 data", G60V2.class),
    CLASS_2_DATA(3, "Class 2 data", G60V3.class),
    CLASS_3_DATA(4, "Class 3 data", G60V4.class);

    private static final Map<Integer, ClassObjectsVariation> _VARIATION_MAP;
    private final int _code;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private ClassObjectsVariation(@Nonnull int code, String title, Class<? extends ObjectInstance> objectClass) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
    }

    @Nonnull
    @CheckReturnValue
    public static ClassObjectsVariation instance(int variationCode) {
        return (ClassObjectsVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return Optional.empty();
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return ClassesGroup.CLASS_OBJECTS;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])ClassObjectsVariation.values());
    }
}

