/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.counters;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.groupCategory.counters.CounterEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.counters.CounterVariation;
import org.rvpf.pap.dnp3.object.groupCategory.counters.FrozenCounterEventVariation;
import org.rvpf.pap.dnp3.object.groupCategory.counters.FrozenCounterVariation;

public enum CountersGroup implements ObjectGroup
{
    COUNTER(20, "Counter", CounterVariation.class),
    FROZEN_COUNTER(21, "Frozen Counter", FrozenCounterVariation.class),
    COUNTER_EVENT(22, "Counter Event", CounterEventVariation.class),
    FROZEN_COUNTER_EVENT(23, "Frozen Counter Event", FrozenCounterEventVariation.class);

    private static final Map<Integer, CountersGroup> _GROUP_MAP;
    private final int _code;
    private final Class<? extends ObjectVariation> _objectVariationClass;
    private final String _title;

    private CountersGroup(@Nonnull int code, String title, Class<? extends ObjectVariation> objectVariationClass) {
        this._code = code;
        this._title = title;
        this._objectVariationClass = objectVariationClass;
    }

    @Nonnull
    @CheckReturnValue
    public static CountersGroup instance(int groupCode) {
        return (CountersGroup)Require.notNull((Object)_GROUP_MAP.get(groupCode));
    }

    @Override
    public GroupCategory getCategory() {
        return GroupCategory.COUNTERS;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Class<? extends ObjectVariation> getObjectVariationClass() {
        return this._objectVariationClass;
    }

    @Override
    public Optional<PointType> getPointType() {
        return Optional.of(PointType.COUNTER);
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _GROUP_MAP = EnumCode.MapFactory.codeMap((Enum[])CountersGroup.values());
    }
}

