/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.counters;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.counters.CountersGroup;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V0;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V1;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V10;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V2;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V5;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V6;
import org.rvpf.pap.dnp3.object.groupCategory.counters.G21V9;

public enum FrozenCounterVariation implements ObjectVariation
{
    ANY(0, "Any", G21V0.class, Optional.empty()),
    UNSIGNED_WITH_FLAG(1, "32-bit with flag", G21V1.class, Optional.of(DataType.UINT32)),
    WORD_WITH_FLAG(2, "16-bit with flag", G21V2.class, Optional.of(DataType.UINT16)),
    UNSIGNED_WITH_FLAG_TIME(5, "32-bit with flag and time", G21V5.class, Optional.of(DataType.UINT32)),
    WORD_WITH_FLAG_TIME(6, "16-bit with flag and time", G21V6.class, Optional.of(DataType.UINT16)),
    UNSIGNED_WITHOUT_FLAG(9, "32-bit without flag", G21V9.class, Optional.of(DataType.UINT32)),
    WORD_WITHOUT_FLAG(10, "16-bit without flag", G21V10.class, Optional.of(DataType.UINT16));

    private static final Map<Integer, FrozenCounterVariation> _VARIATION_MAP;
    private final int _code;
    private final Optional<DataType> _dataType;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private FrozenCounterVariation(@Nonnull int code, @Nonnull String title, Class<? extends ObjectInstance> objectClass, Optional<DataType> dataType) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public static FrozenCounterVariation instance(int variationCode) {
        return (FrozenCounterVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return this._dataType;
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return CountersGroup.FROZEN_COUNTER;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])FrozenCounterVariation.values());
    }
}

