/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.devices;

import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.EnumCode;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.object.groupCategory.devices.DevicesGroup;
import org.rvpf.pap.dnp3.object.groupCategory.devices.G80V0;
import org.rvpf.pap.dnp3.object.groupCategory.devices.G80V1;

public enum InternalIndicationsVariation implements ObjectVariation
{
    ANY(0, "Any", G80V0.class),
    PACKED_FORMAT(1, "Packed format", G80V1.class);

    private static final Map<Integer, InternalIndicationsVariation> _VARIATION_MAP;
    private final int _code;
    private final Class<? extends ObjectInstance> _objectClass;
    private final String _title;

    private InternalIndicationsVariation(@Nonnull int code, String title, Class<? extends ObjectInstance> objectClass) {
        this._code = code;
        this._title = title;
        this._objectClass = objectClass;
    }

    @Nonnull
    @CheckReturnValue
    public static InternalIndicationsVariation instance(int variationCode) {
        return (InternalIndicationsVariation)Require.notNull((Object)_VARIATION_MAP.get(variationCode));
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public Optional<DataType> getDataType() {
        return Optional.empty();
    }

    @Override
    public Class<? extends ObjectInstance> getObjectClass() {
        return this._objectClass;
    }

    @Override
    public ObjectGroup getObjectGroup() {
        return DevicesGroup.INTERNAL_INDICATIONS;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public boolean isPacked() {
        return this == PACKED_FORMAT;
    }

    static {
        _VARIATION_MAP = EnumCode.MapFactory.codeMap((Enum[])InternalIndicationsVariation.values());
    }
}

