/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object.groupCategory.times;

import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.content.IntervalUnit;
import org.rvpf.pap.dnp3.object.groupCategory.times.G50V1;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimeDateVariation;

public final class G50V4
extends G50V1 {
    private int _count;
    private byte _unit;

    @Override
    public void dumpToBuffer(ByteBuffer buffer) {
        super.dumpToBuffer(buffer);
        buffer.putInt(this._count);
        buffer.put(this._unit);
    }

    @CheckReturnValue
    public long getCount() {
        return (long)this._count & 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public int getObjectLength() {
        return super.getObjectLength() + 4 + 1;
    }

    @Override
    public ObjectVariation getObjectVariation() {
        return TimeDateVariation.INDEXED_TIME_INTERVAL;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<IntervalUnit> getUnit() {
        return IntervalUnit.instance(this._unit & 0xFF);
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        super.loadFromBuffer(buffer);
        this._count = buffer.getInt();
        this._unit = buffer.get();
    }

    public void setCount(long count) {
        this._count = (int)count;
    }

    public void setUnit(@Nonnull IntervalUnit unit) {
        this._unit = (byte)unit.getCode();
    }
}

