/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.TransportFunction;

public final class ApplicationLayer {
    public static final int MAXIMUM_FRAGMENT_SIZE = 2048;
    private static final Logger _LOGGER = Logger.getInstance(ApplicationLayer.class);
    private final Association _association;
    private final ByteBuffer _inputBuffer = ByteBuffer.allocate(2048);
    private final AtomicInteger _nextUnsolicitedSequence = new AtomicInteger();
    private final AtomicInteger _nextSolicitedSequence = new AtomicInteger();
    private final ByteBuffer _outputBuffer = ByteBuffer.allocate(2048);

    ApplicationLayer(@Nonnull Association association) {
        this._association = association;
        this._inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this._outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @CheckReturnValue
    public byte nextSolicitedSequence() {
        return (byte)(this._nextSolicitedSequence.getAndIncrement() & 0xF);
    }

    @CheckReturnValue
    public byte nextUnsolicitedSequence() {
        return (byte)(this._nextUnsolicitedSequence.getAndIncrement() & 0xF);
    }

    @Nonnull
    @CheckReturnValue
    public Fragment receive() throws IOException {
        TransportFunction transportFunction = this._association.getTransportFunction();
        this._inputBuffer.clear();
        transportFunction.receive(this._inputBuffer);
        this._inputBuffer.flip();
        Fragment.Header header = Fragment.Header.newInstance(Optional.empty(), !this._association.isWithOutstation());
        Fragment fragment = new Fragment(this._association, header);
        try {
            fragment.loadFromBuffer(this._inputBuffer);
        }
        catch (BufferUnderflowException exception) {
            throw new DNP3ProtocolException(exception, DNP3Messages.APPLICATION_HEADER_INCOMPLETE, new Object[0]);
        }
        _LOGGER.trace(() -> new Message((Messages.Entry)(this._association.isWithOutstation() ? DNP3Messages.RECEIVED_RESPONSE : DNP3Messages.RECEIVED_REQUEST), new Object[]{fragment}));
        return fragment;
    }

    public void send(@Nonnull Fragment fragment) throws IOException {
        _LOGGER.trace(() -> new Message((Messages.Entry)(this._association.isWithOutstation() ? DNP3Messages.SENDING_REQUEST : DNP3Messages.SENDING_RESPONSE), new Object[]{fragment}));
        this._outputBuffer.clear();
        fragment.dumpToBuffer(this._outputBuffer);
        this._outputBuffer.flip();
        this._association.getTransportFunction().send(this._outputBuffer);
    }
}

