/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.transport.ApplicationLayer;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.FunctionCode;
import org.rvpf.pap.dnp3.transport.InternalIndications;

public class ApplicationMessage {
    private final Association _association;
    private final Fragment.Header _header;
    private final LinkedList<Fragment.Item> _items = new LinkedList();

    public ApplicationMessage(@Nonnull Association association, @Nonnull Optional<FunctionCode> functionCode, boolean fromMaster) {
        this._association = association;
        this._header = Fragment.Header.newInstance(functionCode, fromMaster);
    }

    @CheckReturnValue
    public final void add(@Nonnull Fragment.Item item) {
        this._items.add(item);
    }

    public final void receive() throws IOException {
        Fragment fragment;
        ApplicationLayer applicationLayer = this._association.getApplicationLayer();
        boolean needsFirst = true;
        do {
            if ((fragment = applicationLayer.receive()).isFirst() != needsFirst) {
                throw new DNP3ProtocolException(DNP3Messages.UNEXPECTED_FRAGMENT, this._association);
            }
            needsFirst = false;
            Require.ignored((boolean)this._association.getConnectionManager().onReceivedFragment(this._association, fragment));
        } while (!fragment.isLast());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public final boolean send() throws IOException {
        this._header.reset();
        this._header.setFirst();
        ApplicationLayer applicationLayer = this._association.getApplicationLayer();
        Association association = this._association;
        synchronized (association) {
            Fragment fragment = new Fragment(this._association, this._header);
            while (true) {
                if (this._items.isEmpty()) break;
                boolean added = fragment.add(this._items.getFirst());
                if (added) {
                    this._items.removeFirst();
                    continue;
                }
                if (this._items.isEmpty()) {
                    return false;
                }
                if (this._header.isConfirmRequested()) {
                    this._association.expectConfirm();
                }
                fragment.send();
                if (this._header.isInRequest()) {
                    return false;
                }
                if (this._header.isConfirmRequested()) {
                    try {
                        this._association.waitForConfirm();
                    }
                    catch (InterruptedException exception) {
                        throw new InterruptedIOException();
                    }
                }
                this._header.reset();
                this._header.setSequence(this._header.isUnsolicited() ? applicationLayer.nextUnsolicitedSequence() : applicationLayer.nextSolicitedSequence());
                fragment = new Fragment(this._association, this._header);
            }
            this._header.setLast();
            fragment.send();
        }
        return true;
    }

    public void setConfirmRequested() {
        this._header.setConfirmRequested();
    }

    public void setInternalIndications(@Nonnull InternalIndications internalIndications) throws ClassCastException {
        ((Fragment.Header.Response)this._header).setInternalIndications(internalIndications);
    }

    public void setSequence(byte sequence) {
        this._header.setSequence(sequence);
    }

    public void setUnsolicited() {
        this._header.setUnsolicited();
    }
}

