/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.util.concurrent.CountDownLatch;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.transport.ApplicationLayer;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.DataLinkLayer;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.pap.dnp3.transport.TransportFunction;

public abstract class Association {
    private final ApplicationLayer _applicationLayer;
    private volatile CountDownLatch _confirmLatch;
    private final DataLinkLayer _dataLinkLayer;
    private final short _localDeviceAddress;
    private final short _remoteDeviceAddress;
    private final RemoteEndPoint _remoteEndPoint;
    private final TransportFunction _transportFunction;

    protected Association(short localDeviceAddress, short remoteDeviceAddress, @Nonnull RemoteEndPoint remoteEndPoint) {
        this._localDeviceAddress = localDeviceAddress;
        this._remoteDeviceAddress = remoteDeviceAddress;
        this._remoteEndPoint = (RemoteEndPoint)Require.notNull((Object)remoteEndPoint);
        this._applicationLayer = new ApplicationLayer(this);
        this._transportFunction = new TransportFunction(this);
        this._dataLinkLayer = new DataLinkLayer(this);
    }

    public void close() {
        this._dataLinkLayer.close();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Association) {
            Association other = (Association)object;
            return this.getLocalDeviceAddress() == other.getLocalDeviceAddress() && this.getRemoteDeviceAddress() == other.getRemoteDeviceAddress() && this.getRemoteEndPoint() == other.getRemoteEndPoint();
        }
        return false;
    }

    public void expectConfirm() {
        this._confirmLatch = new CountDownLatch(1);
    }

    @Nonnull
    @CheckReturnValue
    public final ApplicationLayer getApplicationLayer() {
        return this._applicationLayer;
    }

    @Nullable
    @CheckReturnValue
    public final Connection getConnection() {
        return this._remoteEndPoint.getConnection();
    }

    @Nonnull
    @CheckReturnValue
    public final ConnectionManager getConnectionManager() {
        return this._remoteEndPoint.getConnectionManager();
    }

    @Nonnull
    @CheckReturnValue
    public final DataLinkLayer getDataLinkLayer() {
        return this._dataLinkLayer;
    }

    @CheckReturnValue
    public final short getLocalDeviceAddress() {
        return this._localDeviceAddress;
    }

    @CheckReturnValue
    public final short getRemoteDeviceAddress() {
        return this._remoteDeviceAddress;
    }

    @Nonnull
    @CheckReturnValue
    public final RemoteEndPoint getRemoteEndPoint() {
        return this._remoteEndPoint;
    }

    @Nonnull
    @CheckReturnValue
    public final TransportFunction getTransportFunction() {
        return this._transportFunction;
    }

    public int hashCode() {
        return Integer.hashCode(this._localDeviceAddress) ^ Integer.hashCode(this._remoteDeviceAddress) ^ System.identityHashCode(this._remoteEndPoint);
    }

    @CheckReturnValue
    public abstract boolean isWithOutstation();

    public void onConfirm() {
        CountDownLatch confirmLatch = this._confirmLatch;
        if (confirmLatch != null) {
            confirmLatch.countDown();
        }
    }

    public String toString() {
        return "[local " + Integer.toHexString(this._localDeviceAddress & 0xFFFF) + ", remote " + Integer.toHexString(this._remoteDeviceAddress & 0xFFFF) + " on " + (String)this._remoteEndPoint.getRemoteProxyName().orElse(null) + "]";
    }

    public void waitForConfirm() throws InterruptedException {
        this._confirmLatch.await();
        this._confirmLatch = null;
    }
}

