/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.Frame;

public final class DataLinkLayer {
    private static final int _FRAME_DATA_LIMIT = 250;
    private static final Logger _LOGGER = Logger.getInstance(DataLinkLayer.class);
    private Frame.FunctionCode _ackOrNack = Frame.SecondaryCode.NACK;
    private final Association _association;
    private boolean _expectedFrameCountBit;
    private final Frame.Sender _frameSender;
    private final BlockingQueue<byte[]> _inputSegments = new LinkedBlockingQueue<byte[]>();
    private volatile boolean _linkActive;
    private final Object _outputMutex = new Object();
    private final AtomicReference<PrimaryState> _primaryState = new AtomicReference();
    private final AtomicReference<SecondaryState> _secondaryState = new AtomicReference();
    private final Object _sendMutex = new Object();
    private volatile CountDownLatch _watchdogLatch;

    public DataLinkLayer(@Nonnull Association association) {
        this._association = association;
        this._frameSender = new Frame.Sender(association.getRemoteEndPoint());
        this._primaryState.set(PrimaryState.SEC_UN_RESET_IDLE);
        this._secondaryState.set(SecondaryState.UN_RESET);
    }

    public void accept(@Nonnull Frame frame) throws IOException {
        block24: {
            Frame.FunctionCode functionCode;
            Frame.Header frameHeader;
            block23: {
                frameHeader = frame.getHeader();
                functionCode = frameHeader.getFunctionCode();
                this._linkActive = true;
                if (!functionCode.isPrimary()) break block23;
                switch ((Frame.PrimaryCode)functionCode) {
                    case UNCONFIRMED_USER_DATA: {
                        if (!frameHeader.isFrameCountValid()) {
                            this._inputSegments.add(frame.getData());
                            break;
                        }
                        break block24;
                    }
                    case CONFIRMED_USER_DATA: {
                        if (frameHeader.isFrameCountValid()) {
                            if (this._secondaryState.get() == SecondaryState.IDLE) {
                                if (frameHeader.getFrameCountBit() == this._expectedFrameCountBit) {
                                    this._expectedFrameCountBit = !this._expectedFrameCountBit;
                                    this._inputSegments.add(frame.getData());
                                }
                                this._send(Frame.SecondaryCode.ACK);
                                break;
                            }
                            this._send(Frame.SecondaryCode.NACK);
                            break;
                        }
                        this._send(Frame.SecondaryCode.NOT_SUPPORTED);
                        break;
                    }
                    case RESET_LINK_STATES: {
                        if (frameHeader.isFrameCountValid()) {
                            this._send(Frame.SecondaryCode.NOT_SUPPORTED);
                            break;
                        }
                        this._expectedFrameCountBit = true;
                        this._send(Frame.SecondaryCode.ACK);
                        this._secondaryState.compareAndSet(SecondaryState.UN_RESET, SecondaryState.IDLE);
                        break;
                    }
                    case REQUEST_LINK_STATUS: {
                        if (frameHeader.isFrameCountValid()) {
                            this._send(Frame.SecondaryCode.NOT_SUPPORTED);
                            break;
                        }
                        this._send(Frame.SecondaryCode.LINK_STATUS);
                        break;
                    }
                    case TEST_LINK_STATES: {
                        if (frameHeader.isFrameCountValid()) {
                            if (this._secondaryState.get() == SecondaryState.IDLE) {
                                if (frameHeader.getFrameCountBit() == this._expectedFrameCountBit) {
                                    this._expectedFrameCountBit = !this._expectedFrameCountBit;
                                    this._send(Frame.SecondaryCode.ACK);
                                    break;
                                }
                                this._send(this._ackOrNack);
                                break;
                            }
                            this._send(Frame.SecondaryCode.NACK);
                            break;
                        }
                        this._send(Frame.SecondaryCode.NOT_SUPPORTED);
                        break;
                    }
                    default: {
                        this._send(Frame.SecondaryCode.NOT_SUPPORTED);
                        break;
                    }
                }
                break block24;
            }
            switch ((Frame.SecondaryCode)functionCode) {
                case ACK: {
                    break;
                }
                case LINK_STATUS: {
                    if (this._primaryState.compareAndSet(PrimaryState.UR_LINK_STATUS_WAIT, PrimaryState.SEC_UN_RESET_IDLE)) {
                        CountDownLatch watchdogLatch = this._watchdogLatch;
                        if (watchdogLatch == null) break;
                        watchdogLatch.countDown();
                        break;
                    }
                    _LOGGER.debug((Messages.Entry)DNP3Messages.IGNORED_FRAME, new Object[]{functionCode, this._association.getRemoteEndPoint().getRemoteProxy(), Integer.toHexString(frameHeader.getSource() & 0xFFFF), Integer.toHexString(frameHeader.getDestination() & 0xFFFF)});
                    break;
                }
                case NACK: {
                    break;
                }
                case NOT_SUPPORTED: {
                    break;
                }
            }
        }
    }

    public void close() {
        this._frameSender.close();
    }

    @Nonnull
    @CheckReturnValue
    public Association getAssociation() {
        return this._association;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CheckReturnValue
    public boolean isLinkActive(long replyTimeout) throws IOException {
        if (this._linkActive) return this._linkActive;
        if (this._primaryState.compareAndSet(PrimaryState.SEC_UN_RESET_IDLE, PrimaryState.UR_LINK_STATUS_WAIT)) {
            this._watchdogLatch = new CountDownLatch(1);
            try {
                Frame sentFrame = this._send(Frame.PrimaryCode.REQUEST_LINK_STATUS);
                if (this._watchdogLatch.await(replyTimeout, TimeUnit.MILLISECONDS)) return this._linkActive;
                this._primaryState.compareAndSet(PrimaryState.UR_LINK_STATUS_WAIT, PrimaryState.SEC_UN_RESET_IDLE);
                Frame.Header frameHeader = sentFrame.getHeader();
                _LOGGER.debug((Messages.Entry)DNP3Messages.FRAME_RESPONSE_TIMEOUT, new Object[]{frameHeader.getFunctionCode(), this._association.getRemoteEndPoint().getRemoteProxy(), Integer.toHexString(frameHeader.getSource() & 0xFFFF), Integer.toHexString(frameHeader.getDestination() & 0xFFFF)});
                return this._linkActive;
            }
            catch (InterruptedException exception) {
                throw (IOException)new InterruptedIOException().initCause(exception);
            }
            finally {
                this._watchdogLatch = null;
            }
        } else {
            _LOGGER.warn((Messages.Entry)DNP3Messages.UNEXPECTED_LINK_STATE, new Object[]{this._association, PrimaryState.SEC_UN_RESET_IDLE, this._primaryState});
        }
        return this._linkActive;
    }

    public void receive(@Nonnull ByteBuffer segmentBuffer) throws IOException {
        byte[] inputSegment;
        try {
            inputSegment = this._inputSegments.take();
        }
        catch (InterruptedException exception) {
            throw new InterruptedIOException();
        }
        segmentBuffer.put(inputSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(@Nonnull ByteBuffer segmentBuffer) throws IOException {
        Object object = this._sendMutex;
        synchronized (object) {
            while (segmentBuffer.hasRemaining()) {
                this._send(Frame.PrimaryCode.UNCONFIRMED_USER_DATA, false, false, segmentBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Frame _send(@Nonnull Frame.FunctionCode functionCode) throws IOException {
        Frame frame;
        Object object = this._outputMutex;
        synchronized (object) {
            Frame.Header header = new Frame.Header(functionCode, 0, this._association.getLocalDeviceAddress(), this._association.getRemoteDeviceAddress(), false, false, false);
            Connection connection = this._association.getConnection();
            if (connection == null) {
                throw new ConnectException();
            }
            frame = new Frame(header, Frame.NO_DATA);
            this._frameSender.send(connection, frame);
            if (functionCode == Frame.SecondaryCode.ACK || functionCode == Frame.SecondaryCode.NACK) {
                this._ackOrNack = functionCode;
            }
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _send(@Nonnull Frame.PrimaryCode functionCode, boolean frameCountValid, boolean frameCountBit, ByteBuffer segmentBuffer) throws IOException {
        Object object = this._outputMutex;
        synchronized (object) {
            int frameDataLength = Math.min(segmentBuffer.remaining(), 250);
            Frame.Header header = new Frame.Header(functionCode, frameDataLength, this._association.getLocalDeviceAddress(), this._association.getRemoteDeviceAddress(), frameCountBit, frameCountValid, false);
            byte[] data = new byte[frameDataLength];
            segmentBuffer.get(data);
            this._frameSender.send(this._association.getConnection(), new Frame(header, data));
        }
    }

    static enum SecondaryState {
        UN_RESET,
        IDLE;

    }

    protected static enum PrimaryState {
        SEC_UN_RESET_IDLE,
        SEC_RESET_IDLE,
        RESET_LINK_WAIT_1,
        RESET_LINK_WAIT_2,
        UR_LINK_STATUS_WAIT,
        TEST_WAIT,
        CFMD_DATA_WAIT,
        R_LINK_STATUS_WAIT;

    }
}

