/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.object.ObjectHeader;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.InternalIndication;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.FunctionCode;
import org.rvpf.pap.dnp3.transport.InternalIndications;

public final class Fragment {
    private final Association _association;
    private final Header _header;
    private final LinkedList<Item> _items = new LinkedList();
    private final int _maxSize;
    private int _size;

    public Fragment(@Nonnull Association association, @Nonnull Header header) {
        this._association = association;
        this._header = header;
        this._maxSize = this._association.getRemoteEndPoint().getMaxFragmentSize();
        this._size = this._header.size();
    }

    @CheckReturnValue
    public boolean add(@Nonnull Item item) {
        ObjectHeader objectHeader = item.getObjectHeader();
        int size = this._size;
        try {
            size += objectHeader.getLength();
        }
        catch (DNP3ProtocolException exception) {
            throw new IllegalArgumentException("Bad message item header: " + exception.getMessage());
        }
        Optional<ObjectInstance[]> objectInstances = item.getObjectInstances();
        if (objectInstances.isPresent()) {
            for (ObjectInstance object : objectInstances.get()) {
                ObjectVariation objectHeaderVariation;
                try {
                    objectHeaderVariation = objectHeader.getObjectVariation();
                }
                catch (DNP3ProtocolException exception) {
                    throw new InternalError(exception);
                }
                if (object.getObjectVariation() != objectHeaderVariation) {
                    throw new IllegalArgumentException("Inconsistent object variation: " + object.getObjectVariation().getObjectClass().getSimpleName() + "!=" + objectHeaderVariation.getObjectClass().getSimpleName());
                }
                size += object.getObjectLength();
            }
        }
        if (size > this._maxSize) {
            return false;
        }
        this._items.add(item);
        this._size = size;
        return true;
    }

    public void dumpToBuffer(@Nonnull ByteBuffer buffer) throws IOException {
        this._header.dumpToBuffer(buffer);
        for (Item item : this.getItems()) {
            item.getObjectHeader().dumpToBuffer(buffer, item.getObjectInstances());
        }
    }

    @Nonnull
    @CheckReturnValue
    public final Association getAssociation() {
        return this._association;
    }

    @Nonnull
    @CheckReturnValue
    public FunctionCode getFunctionCode() {
        return this._header.getFunctionCode();
    }

    @Nonnull
    @CheckReturnValue
    public Header getHeader() {
        return this._header;
    }

    @Nonnull
    @CheckReturnValue
    public InternalIndications getInternalIndications() throws ClassCastException {
        return ((Header.Response)this._header).getInternalIndications();
    }

    @Nonnull
    @CheckReturnValue
    public LinkedList<Item> getItems() {
        return this._items;
    }

    @CheckReturnValue
    public int getMaxItemSize() {
        return this._maxSize - this._header.size();
    }

    @CheckReturnValue
    public byte getSequence() {
        return this._header.getSequence();
    }

    @CheckReturnValue
    public boolean isConfirmRequested() {
        return this._header.isConfirmRequested();
    }

    @CheckReturnValue
    public final boolean isFirst() {
        return this._header.isFirst();
    }

    @CheckReturnValue
    public final boolean isLast() {
        return this._header.isLast();
    }

    @CheckReturnValue
    public boolean isRequest() {
        return this._header.isInRequest();
    }

    @CheckReturnValue
    public boolean isUnsolicited() {
        return this._header.isUnsolicited();
    }

    public void loadFromBuffer(@Nonnull ByteBuffer buffer) throws IOException {
        this._header.loadFromBuffer(buffer);
        if (!this.isRequest()) {
            InternalIndications internalIndications = this.getInternalIndications();
            if (internalIndications.hasNoFuncCodeSupport()) {
                Logger.getInstance(this.getClass()).trace((Messages.Entry)DNP3Messages.NO_FUNC_CODE_SUPPORT, new Object[]{this._association, this.getFunctionCode()});
            }
            if (internalIndications.hasObjectUnknown()) {
                throw new DNP3ProtocolException(DNP3Messages.OBJECT_UNKNOWN, this._association);
            }
            if (internalIndications.hasParameterError()) {
                throw new DNP3ProtocolException(DNP3Messages.PARAMETER_ERROR, this._association);
            }
        }
        while (buffer.hasRemaining()) {
            Optional<Object> objectInstances;
            Optional<Object> objectSizes;
            Optional<Number[]> objectIndices;
            ObjectHeader objectHeader = ObjectHeader.newInstance(buffer);
            int objectCount = objectHeader.getObjectCount();
            if (objectCount > 0 && (this._header.getFunctionCode().needsValues() || objectHeader.getPrefixCode() != ObjectHeader.PrefixCode.NONE)) {
                switch (objectHeader.getPrefixCode()) {
                    case INDEX_BYTE: 
                    case INDEX_SHORT: 
                    case INDEX_INT: {
                        objectIndices = Optional.of(new Number[objectCount]);
                        objectSizes = Optional.empty();
                        break;
                    }
                    case SIZE_BYTE: 
                    case SIZE_SHORT: 
                    case SIZE_INT: {
                        objectIndices = Optional.empty();
                        objectSizes = Optional.of(new Number[objectCount]);
                        break;
                    }
                    default: {
                        objectIndices = Optional.empty();
                        objectSizes = Optional.empty();
                    }
                }
                objectInstances = this._header.getFunctionCode().needsValues() ? Optional.of(new ObjectInstance[objectCount]) : Optional.empty();
                objectHeader.loadInstancesFromBuffer(buffer, objectIndices, objectSizes, objectInstances);
            } else {
                objectIndices = Optional.empty();
                objectSizes = Optional.empty();
                objectInstances = Optional.empty();
            }
            Require.success((boolean)this.add(new Item(objectHeader, objectIndices, objectSizes, objectInstances)));
        }
    }

    public void send() throws IOException {
        this._association.getApplicationLayer().send(this);
    }

    public void setSequence(byte sequence) {
        this._header.setSequence(sequence);
    }

    public void setUnsolicited() {
        this._header.setUnsolicited();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._association);
        builder.append(':');
        builder.append(this._header);
        boolean first = true;
        for (Item item : this._items) {
            if (first) {
                builder.append('/');
            }
            builder.append(item);
            first = false;
        }
        return builder.toString();
    }

    public static final class Item {
        private final ObjectHeader _objectHeader;
        private final Optional<Number[]> _objectIndexes;
        private final Optional<ObjectInstance[]> _objectInstances;
        private final Optional<Number[]> _objectSizes;

        public Item(@Nonnull ObjectHeader objectHeader) {
            this(objectHeader, Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Item(@Nonnull ObjectHeader objectHeader, @Nonnull Optional<ObjectInstance[]> objectInstances) {
            this(objectHeader, Optional.empty(), Optional.empty(), objectInstances);
        }

        public Item(@Nonnull ObjectHeader objectHeader, @Nonnull Optional<Number[]> objectIndexes, @Nonnull Optional<Number[]> objectSizes, @Nonnull Optional<ObjectInstance[]> objectInstances) {
            this._objectHeader = objectHeader;
            Require.success((!objectIndexes.isPresent() || !objectInstances.isPresent() || objectIndexes.get().length == objectInstances.get().length ? 1 : 0) != 0);
            Require.success((!objectSizes.isPresent() || !objectInstances.isPresent() || objectSizes.get().length == objectInstances.get().length ? 1 : 0) != 0);
            Require.success((!objectInstances.isPresent() || objectInstances.get().length > 0 ? 1 : 0) != 0);
            this._objectIndexes = objectIndexes;
            this._objectSizes = objectSizes;
            this._objectInstances = objectInstances;
        }

        @Nonnull
        @CheckReturnValue
        public Indexes getIndexes() {
            return new Indexes();
        }

        @Nonnull
        @CheckReturnValue
        public ObjectHeader getObjectHeader() {
            return this._objectHeader;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Number[]> getObjectIndexes() {
            return this._objectIndexes;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<ObjectInstance[]> getObjectInstances() {
            return this._objectInstances;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Number[]> getObjectSizes() {
            return this._objectSizes;
        }

        @Nonnull
        @CheckReturnValue
        public ObjectVariation getObjectVariation() {
            try {
                return this._objectHeader.getObjectVariation();
            }
            catch (DNP3ProtocolException exception) {
                throw new InternalError(exception);
            }
        }

        @Nonnull
        @CheckReturnValue
        public Optional<PointType> getPointType() {
            return this.getObjectVariation().getPointType();
        }

        @Nonnull
        @CheckReturnValue
        public ObjectHeader.PrefixCode getPrefixCode() throws DNP3ProtocolException {
            return this._objectHeader.getPrefixCode();
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Object> getRange() {
            return this._objectHeader.getRange();
        }

        @Nonnull
        @CheckReturnValue
        public ObjectHeader.RangeCode getRangeCode() throws DNP3ProtocolException {
            return this._objectHeader.getRangeCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this._objectHeader);
            if (this._objectInstances.isPresent()) {
                boolean first = true;
                for (ObjectInstance objectInstance : this._objectInstances.get()) {
                    if (!first) {
                        builder.append(',');
                    }
                    builder.append(objectInstance);
                    first = false;
                }
            }
            return builder.toString();
        }

        public final class Indexes
        implements Iterable<Integer>,
        Iterator<Integer> {
            private int[] _indices;
            private int _length;
            private int _position;
            private final int _start;
            private final int _stop;

            Indexes() {
                ObjectHeader.RangeCode rangeCode;
                ObjectHeader.PrefixCode prefixCode;
                try {
                    prefixCode = Item.this.getPrefixCode();
                }
                catch (DNP3ProtocolException exception) {
                    throw new InternalError(exception);
                }
                switch (prefixCode) {
                    case NONE: {
                        break;
                    }
                    case INDEX_BYTE: 
                    case INDEX_SHORT: 
                    case INDEX_INT: {
                        Number[] prefixes = Item.this.getObjectIndexes().get();
                        this._indices = new int[prefixes.length];
                        this._length = this._indices.length;
                        for (int i = 0; i < prefixes.length; ++i) {
                            this._indices[i] = prefixes[i].intValue();
                        }
                        this._start = -1;
                        this._stop = -1;
                        return;
                    }
                    default: {
                        Logger.getInstance(this.getClass()).warn((Messages.Entry)DNP3Messages.PREFIX_CODE_NOT_SUPPORTED, new Object[]{prefixCode});
                        this._start = -1;
                        this._stop = -1;
                        return;
                    }
                }
                try {
                    rangeCode = Item.this.getRangeCode();
                }
                catch (DNP3ProtocolException exception) {
                    throw new InternalError(exception);
                }
                switch (rangeCode) {
                    case START_STOP_INDEX_BYTE: 
                    case START_STOP_ADDRESS_BYTE: {
                        byte[] range = (byte[])Item.this.getRange().get();
                        this._start = range[0] & 0xFF;
                        this._stop = range[1] & 0xFF;
                        this._length = 1 + this._stop - this._start;
                        break;
                    }
                    case START_STOP_INDEX_SHORT: 
                    case START_STOP_ADDRESS_SHORT: {
                        short[] range = (short[])Item.this.getRange().get();
                        this._start = range[0] & 0xFFFF;
                        this._stop = range[1] & 0xFFFF;
                        this._length = 1 + this._stop - this._start;
                        break;
                    }
                    case START_STOP_INDEX_INT: 
                    case START_STOP_ADDRESS_INT: {
                        int[] range = (int[])Item.this.getRange().get();
                        this._start = range[0];
                        this._stop = range[1];
                        this._length = 1 + this._stop - this._start;
                        break;
                    }
                    default: {
                        Logger.getInstance(this.getClass()).warn((Messages.Entry)DNP3Messages.RANGE_CODE_NOT_SUPPORTED, new Object[]{rangeCode});
                        this._start = -1;
                        this._stop = -1;
                        return;
                    }
                }
            }

            @CheckReturnValue
            public int getLength() {
                return this._length;
            }

            @CheckReturnValue
            public int getPosition() {
                return this._position - 1;
            }

            @CheckReturnValue
            public int getStart() {
                return this._start;
            }

            @CheckReturnValue
            public int getStop() {
                return this._stop;
            }

            @Override
            public boolean hasNext() {
                return this._position < this._length;
            }

            @CheckReturnValue
            public boolean isStartStop() {
                return this._start >= 0;
            }

            @Override
            public Iterator<Integer> iterator() {
                this._position = 0;
                return this;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this._start + this._position++;
            }
        }
    }

    public static abstract class Header {
        private static final byte _CON_MASK = 32;
        private static final byte _FIN_MASK = 64;
        private static final byte _FIR_MASK = -128;
        private static final byte _SEQ_MASK = 15;
        private static final byte _UNS_MASK = 16;
        private byte _applicationControl;
        private FunctionCode _functionCode;

        Header(@Nonnull Optional<FunctionCode> functionCode) {
            this._functionCode = functionCode.orElse(null);
        }

        @Nonnull
        @CheckReturnValue
        public static Header newInstance(@Nonnull Optional<FunctionCode> functionCode, boolean fromMaster) {
            return fromMaster ? new Request(functionCode) : new Response(functionCode);
        }

        public void dumpToBuffer(@Nonnull ByteBuffer buffer) {
            buffer.put(this._applicationControl);
            buffer.put((byte)this.getFunctionCode().getCode());
        }

        @Nonnull
        @CheckReturnValue
        public final FunctionCode getFunctionCode() {
            return (FunctionCode)Require.notNull((Object)this._functionCode);
        }

        @CheckReturnValue
        public final byte getSequence() {
            return (byte)(this._applicationControl & 0xF);
        }

        @CheckReturnValue
        public final boolean isConfirmRequested() {
            return (this._applicationControl & 0x20) != 0;
        }

        @CheckReturnValue
        public final boolean isFirst() {
            return (this._applicationControl & 0xFFFFFF80) != 0;
        }

        @CheckReturnValue
        public abstract boolean isInRequest();

        @CheckReturnValue
        public final boolean isLast() {
            return (this._applicationControl & 0x40) != 0;
        }

        @CheckReturnValue
        public final boolean isLoaded() {
            return this._functionCode != null;
        }

        @CheckReturnValue
        public final boolean isUnsolicited() {
            return (this._applicationControl & 0x10) != 0;
        }

        public void loadFromBuffer(@Nonnull ByteBuffer buffer) throws IOException {
            this._applicationControl = buffer.get();
            byte code = buffer.get();
            this._functionCode = FunctionCode.instance(code & 0xFF);
        }

        public final void reset() {
            this._applicationControl = (byte)(this._applicationControl & 0x3F);
        }

        public final void setConfirmRequested() {
            this._applicationControl = (byte)(this._applicationControl | 0x20);
        }

        public final void setFirst() {
            this._applicationControl = (byte)(this._applicationControl | 0xFFFFFF80);
        }

        public final void setLast() {
            this._applicationControl = (byte)(this._applicationControl | 0x40);
        }

        public final void setSequence(byte sequence) {
            this._applicationControl = (byte)(this._applicationControl & 0xFFFFFFF0 | sequence & 0xF);
        }

        public final void setUnsolicited() {
            this._applicationControl = (byte)(this._applicationControl | 0x10);
        }

        @CheckReturnValue
        public abstract int size();

        public String toString() {
            StringBuilder builder = new StringBuilder(this._functionCode.toString());
            Header._toString(builder, this.isFirst(), "FIR");
            Header._toString(builder, this.isLast(), "FIN");
            Header._toString(builder, this.isUnsolicited(), "UNS");
            Header._toString(builder, this.isConfirmRequested(), "CON");
            Header._toString(builder, true, Integer.toHexString(this.getSequence()).toUpperCase(Locale.ROOT));
            if (this instanceof Response) {
                builder.append(((Response)this).getInternalIndications());
            }
            return builder.toString();
        }

        private static void _toString(StringBuilder builder, boolean condition, String text) {
            if (condition) {
                builder.append(',');
                builder.append(text);
            }
        }

        public static final class Response
        extends Header {
            private final InternalIndications _internalIndications = new InternalIndications(new InternalIndication[0]);

            Response(@Nonnull Optional<FunctionCode> functionCode) {
                super(functionCode);
            }

            @Override
            public void dumpToBuffer(@Nonnull ByteBuffer buffer) {
                super.dumpToBuffer(buffer);
                buffer.putShort(this._internalIndications.getInternalIndications());
            }

            @Nonnull
            @CheckReturnValue
            public InternalIndications getInternalIndications() {
                return this._internalIndications;
            }

            @Override
            public boolean isInRequest() {
                return false;
            }

            @Override
            public void loadFromBuffer(@Nonnull ByteBuffer buffer) throws IOException {
                super.loadFromBuffer(buffer);
                this.setInternalIndications(new InternalIndications(buffer.getShort()));
            }

            public void setInternalIndications(@Nonnull InternalIndications internalIndications) {
                this._internalIndications.set(internalIndications);
            }

            @Override
            public int size() {
                return 4;
            }
        }

        public static final class Request
        extends Header {
            Request(@Nonnull Optional<FunctionCode> functionCode) {
                super(functionCode);
                this.setFirst();
                this.setLast();
            }

            @Override
            public boolean isInRequest() {
                return true;
            }

            @Override
            public int size() {
                return 2;
            }
        }
    }
}

