/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Traces;
import org.rvpf.pap.TraceBuffer;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.transport.CRC;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;

public final class Frame {
    public static final int MAXIMUM_DATA_SIZE = 250;
    public static final int MAXIMUM_FRAME_SIZE = 292;
    public static final int MINIMUM_FRAME_SIZE = 10;
    public static final byte[] NO_DATA = new byte[0];
    static final int _BYTE_BITS = 8;
    static final int _BYTE_MASK = 255;
    static final int _DATA_BLOCK_SIZE = 16;
    static final int _DFC_MASK = 16;
    static final int _DIR_MASK = 128;
    static final int _FCB_MASK = 32;
    static final int _FCV_MASK = 16;
    static final int _FRAME_DATA_LIMIT = 250;
    static final int _FUNCTION_CODE_MASK = 15;
    static final int _HEADER_LENGTH = 5;
    static final int _PRM_MASK = 64;
    static final short _START_FIELD = 25605;
    private final byte[] _data;
    private final Header _header;

    Frame(@Nonnull Header header, @Nonnull byte[] data) {
        this._header = header;
        this._data = data;
    }

    @Nonnull
    @CheckReturnValue
    public byte[] getData() {
        return this._data;
    }

    @Nonnull
    @CheckReturnValue
    public Header getHeader() {
        return this._header;
    }

    private static abstract class _Traced {
        private final Optional<String> _proxyName;
        private final Traces _traces;

        _Traced(@Nonnull RemoteEndPoint remoteEndPoint) {
            this._proxyName = remoteEndPoint.getRemoteProxyName();
            this._traces = remoteEndPoint.getConnectionManager().getTraces();
        }

        @CheckReturnValue
        protected final boolean isTracesEnabled() {
            return this._traces.isEnabled();
        }

        @Nonnull
        @CheckReturnValue
        protected final TraceBuffer newTraceBuffer() {
            return new TraceBuffer(this._traces.isEnabled());
        }

        protected final void trace(@Nonnull String message) {
            if (this._traces.isEnabled()) {
                this._traces.add(this._proxyName, (Object)message);
                this._traces.commit();
            }
        }

        void close() {
            if (this._traces.isEnabled()) {
                this._traces.commit();
            }
        }
    }

    static final class Sender
    extends _Traced {
        static final Logger _LOGGER = Logger.getInstance(Sender.class);
        private final CRC _crc = new CRC();
        private final ByteBuffer _frameBuffer = ByteBuffer.allocate(292);
        private final TraceBuffer _sentBytes = this.newTraceBuffer();

        Sender(@Nonnull RemoteEndPoint remoteEndPoint) {
            super(remoteEndPoint);
            this.trace("Sender begins");
        }

        @Override
        void close() {
            this.trace("Sender ends");
            super.close();
        }

        void send(@Nonnull Connection connection, @Nonnull Frame frame) throws IOException {
            Header header = frame.getHeader();
            this._sendHeader(connection.isOnMaster(), header);
            byte[] data = frame.getData();
            for (int offset = 0; offset < data.length; offset += this._sendData(data, offset)) {
            }
            this._frameBuffer.flip();
            connection.send(this._frameBuffer);
            if (this.isTracesEnabled()) {
                this.trace("Tx: " + this._sentBytes);
                this._sentBytes.reset();
            }
            _LOGGER.trace((Messages.Entry)DNP3Messages.SENT_TO, new Object[]{header.getFunctionCode(), connection, Integer.toHexString(header.getSource() & 0xFFFF), Integer.toHexString(header.getDestination() & 0xFFFF)});
        }

        private void _sendByte(byte b) {
            this._frameBuffer.put(b);
            this._sentBytes.append(b);
        }

        private void _sendByteThruCRC(byte b) {
            this._crc.update(b);
            this._sendByte(b);
        }

        private int _sendData(byte[] data, int offset) {
            int length = Math.min(data.length - offset, 16);
            this._crc.reset();
            for (int i = 0; i < length; ++i) {
                this._sendByteThruCRC(data[offset++]);
            }
            this._sendWord((short)this._crc.getValue());
            return length;
        }

        private void _sendHeader(boolean onMaster, Header header) {
            FunctionCode functionCode = header.getFunctionCode();
            int control = functionCode.getCode();
            if (onMaster) {
                control |= 0x80;
            }
            if (functionCode.isPrimary()) {
                control |= 0x40;
                if (header.isFrameCountValid()) {
                    if (header.getFrameCountBit()) {
                        control |= 0x20;
                    }
                    control |= 0x10;
                }
            } else if (header.hasDataFlowControl()) {
                control |= 0x10;
            }
            this._frameBuffer.clear();
            this._crc.reset();
            this._sendWordThruCRC((short)25605);
            this._sendByteThruCRC((byte)(5 + header.getDataLength()));
            this._sendByteThruCRC((byte)control);
            this._sendWordThruCRC(header.getDestination());
            this._sendWordThruCRC(header.getSource());
            this._sendWord((short)this._crc.getValue());
        }

        private void _sendWord(short w) {
            this._sendByte((byte)w);
            this._sendByte((byte)(w >> 8));
        }

        private void _sendWordThruCRC(short w) {
            this._sendByteThruCRC((byte)w);
            this._sendByteThruCRC((byte)(w >> 8));
        }
    }

    static final class Receiver
    extends _Traced {
        static final Logger _LOGGER = Logger.getInstance(Receiver.class);
        private final CRC _crc = new CRC();
        private final ByteBuffer _frameBuffer = ByteBuffer.allocate(292);
        private final TraceBuffer _receivedBytes;

        Receiver(@Nonnull RemoteEndPoint remoteEndPoint) {
            super(remoteEndPoint);
            this._frameBuffer.flip();
            this._receivedBytes = this.newTraceBuffer();
            this.trace("Receiver begins");
        }

        @Override
        void close() {
            this.trace("Receiver ends");
            super.close();
        }

        @Nonnull
        @CheckReturnValue
        Frame receive(@Nonnull Connection connection) throws IOException {
            byte[] data;
            Header header;
            try {
                header = this._receiveHeader(connection);
                data = new byte[header.getDataLength()];
                for (int offset = 0; offset < data.length; offset += this._receiveData(connection, data, offset)) {
                }
            }
            catch (IOException exception) {
                this._frameBuffer.clear();
                this._frameBuffer.flip();
                throw exception;
            }
            if (this.isTracesEnabled()) {
                this.trace("Rx: " + this._receivedBytes);
                this._receivedBytes.reset();
            }
            _LOGGER.trace((Messages.Entry)DNP3Messages.RECEIVED_FROM, new Object[]{header.getFunctionCode(), connection, Integer.toHexString(header.getSource() & 0xFFFF), Integer.toHexString(header.getDestination() & 0xFFFF)});
            return new Frame(header, data);
        }

        private byte _receiveByte(Connection connection) throws IOException {
            if (!this._frameBuffer.hasRemaining()) {
                this._frameBuffer.clear();
                connection.receive(this._frameBuffer);
                this._frameBuffer.flip();
                if (!this._frameBuffer.hasRemaining()) {
                    throw new ClosedChannelException();
                }
            }
            byte b = this._frameBuffer.get();
            this._receivedBytes.append(b);
            return b;
        }

        private byte _receiveByteThruCRC(Connection connection) throws IOException {
            byte b = this._receiveByte(connection);
            this._crc.update(b);
            return b;
        }

        private int _receiveData(Connection connection, byte[] data, int offset) throws IOException {
            int length = Math.min(data.length - offset, 16);
            this._crc.reset();
            try {
                for (int i = 0; i < length; ++i) {
                    data[offset++] = this._receiveByteThruCRC(connection);
                }
            }
            catch (IndexOutOfBoundsException exception) {
                throw new DNP3ProtocolException(DNP3Messages.SEGMENT_BUFFER_OVERFLOW, new Object[0]);
            }
            if (this._receiveWord(connection) != (short)this._crc.getValue()) {
                throw new DNP3ProtocolException(DNP3Messages.BAD_CRC, new Object[0]);
            }
            return length;
        }

        private Header _receiveHeader(Connection connection) throws IOException {
            boolean dataFlowControl;
            boolean frameCountValid;
            boolean frameCountBit;
            Enum functionCode;
            this._crc.reset();
            short startField = this._receiveWordThruCRC(connection);
            if (startField != 25605) {
                throw new DNP3ProtocolException(DNP3Messages.INVALID_START_FIELD, String.valueOf(startField));
            }
            int length = this._receiveByteThruCRC(connection) & 0xFF;
            if (length < 5 || length > 255) {
                throw new DNP3ProtocolException(DNP3Messages.INVALID_FRAME_LENGTH, String.valueOf(length));
            }
            int control = this._receiveByteThruCRC(connection) & 0xFF;
            int code = control & 0xF;
            if ((control & 0x40) != 0) {
                functionCode = PrimaryCode.instance(code);
                frameCountBit = (control & 0x20) != 0;
                frameCountValid = (control & 0x10) != 0;
                dataFlowControl = false;
            } else {
                functionCode = SecondaryCode.instance(code);
                frameCountBit = false;
                frameCountValid = false;
                dataFlowControl = (control & 0x10) != 0;
            }
            int dataLength = length - 5;
            if ((control & 0x80) != 0 == connection.isOnMaster()) {
                throw new DNP3ProtocolException(DNP3Messages.INVERTED_DIR_BIT, new Object[0]);
            }
            if (functionCode == PrimaryCode.CONFIRMED_USER_DATA || functionCode == PrimaryCode.UNCONFIRMED_USER_DATA) {
                if (dataLength < 1) {
                    throw new DNP3ProtocolException(DNP3Messages.MISSING_FRAME_DATA, String.valueOf(functionCode));
                }
            } else if (dataLength != 0) {
                throw new DNP3ProtocolException(DNP3Messages.UNEXPECTED_FRAME_DATA, String.valueOf(functionCode));
            }
            short destination = this._receiveWordThruCRC(connection);
            short source = this._receiveWordThruCRC(connection);
            if (this._receiveWord(connection) != (short)this._crc.getValue()) {
                throw new DNP3ProtocolException(DNP3Messages.BAD_CRC, new Object[0]);
            }
            return new Header((FunctionCode)((Object)functionCode), dataLength, source, destination, frameCountBit, frameCountValid, dataFlowControl);
        }

        private short _receiveWord(Connection connection) throws IOException {
            byte low = this._receiveByte(connection);
            byte high = this._receiveByte(connection);
            return (short)(high << 8 | low & 0xFF);
        }

        private short _receiveWordThruCRC(Connection connection) throws IOException {
            short w = this._receiveWord(connection);
            this._crc.update(w & 0xFF);
            this._crc.update(w >> 8);
            return w;
        }
    }

    public static final class Header {
        private final boolean _dataFlowControl;
        private final int _dataLength;
        private final short _destination;
        private final boolean _frameCountBit;
        private final boolean _frameCountValid;
        private final FunctionCode _functionCode;
        private final short _source;

        Header(@Nonnull FunctionCode functionCode, int dataLength, short source, short destination, boolean frameCountBit, boolean frameCountValid, boolean dataFlowControl) {
            this._functionCode = functionCode;
            this._dataLength = dataLength;
            this._source = source;
            this._destination = destination;
            this._frameCountBit = frameCountBit;
            this._frameCountValid = frameCountValid;
            this._dataFlowControl = dataFlowControl;
        }

        @CheckReturnValue
        public int getDataLength() {
            return this._dataLength;
        }

        @CheckReturnValue
        public short getDestination() {
            return this._destination;
        }

        @CheckReturnValue
        public boolean getFrameCountBit() {
            return this._frameCountBit;
        }

        @Nonnull
        @CheckReturnValue
        public FunctionCode getFunctionCode() {
            return this._functionCode;
        }

        @CheckReturnValue
        public short getSource() {
            return this._source;
        }

        @CheckReturnValue
        public boolean hasDataFlowControl() {
            return this._dataFlowControl;
        }

        @CheckReturnValue
        public boolean isFrameCountValid() {
            return this._frameCountValid;
        }
    }

    public static interface FunctionCode {
        public static final int MAXIMUM_VALUE = 15;

        @CheckReturnValue
        public int getCode();

        @CheckReturnValue
        public boolean isPrimary();
    }

    public static enum SecondaryCode implements FunctionCode
    {
        ACK(0),
        NACK(1),
        LINK_STATUS(11),
        NOT_SUPPORTED(15);

        private static final SecondaryCode[] _CODE_ARRAY;
        private final int _code;

        private SecondaryCode(int code) {
            this._code = code;
        }

        @Nonnull
        @CheckReturnValue
        public static SecondaryCode instance(int code) throws DNP3ProtocolException {
            if (code < 0 || _CODE_ARRAY.length <= code) {
                throw new DNP3ProtocolException(DNP3Messages.UNEXPECTED_FRAME_DATA, String.valueOf(code));
            }
            return _CODE_ARRAY[code];
        }

        @Override
        public int getCode() {
            return this._code;
        }

        @Override
        public boolean isPrimary() {
            return false;
        }

        static {
            _CODE_ARRAY = new SecondaryCode[16];
            Arrays.stream(SecondaryCode.values()).forEach(code -> {
                SecondaryCode._CODE_ARRAY[code.getCode()] = code;
            });
        }
    }

    public static enum PrimaryCode implements FunctionCode
    {
        RESET_LINK_STATES(0),
        TEST_LINK_STATES(2),
        CONFIRMED_USER_DATA(3),
        UNCONFIRMED_USER_DATA(4),
        REQUEST_LINK_STATUS(9);

        private static final PrimaryCode[] _CODE_ARRAY;
        private final int _code;

        private PrimaryCode(int code) {
            this._code = code;
        }

        @Nonnull
        @CheckReturnValue
        public static PrimaryCode instance(int code) throws DNP3ProtocolException {
            if (code < 0 || _CODE_ARRAY.length <= code) {
                throw new DNP3ProtocolException(DNP3Messages.UNEXPECTED_FRAME_DATA, String.valueOf(code));
            }
            return _CODE_ARRAY[code];
        }

        @Override
        public int getCode() {
            return this._code;
        }

        @Override
        public boolean isPrimary() {
            return true;
        }

        static {
            _CODE_ARRAY = new PrimaryCode[16];
            Arrays.stream(PrimaryCode.values()).forEach(code -> {
                PrimaryCode._CODE_ARRAY[code.getCode()] = code;
            });
        }
    }
}

