/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.object.content.InternalIndication;

public final class InternalIndications {
    private short _internalIndications;

    public InternalIndications(InternalIndication ... internalIndications) {
        for (InternalIndication internalIndication : internalIndications) {
            this._internalIndications = (short)(this._internalIndications | internalIndication.getMask());
        }
    }

    public InternalIndications(@Nonnull short internalIndications) {
        this._internalIndications = internalIndications;
    }

    public void add(@Nonnull InternalIndications internalIndications) {
        this._internalIndications = (short)(this._internalIndications | internalIndications.getInternalIndications());
    }

    @CheckReturnValue
    public short getInternalIndications() {
        return this._internalIndications;
    }

    @CheckReturnValue
    public boolean hasAlreadyExecuting() {
        return this._getInternalIndication(InternalIndication.ALREADY_EXECUTING);
    }

    @CheckReturnValue
    public boolean hasBroadcast() {
        return this._getInternalIndication(InternalIndication.BROADCAST);
    }

    @CheckReturnValue
    public boolean hasClass1Events() {
        return this._getInternalIndication(InternalIndication.CLASS_1_EVENTS);
    }

    @CheckReturnValue
    public boolean hasClass2Events() {
        return this._getInternalIndication(InternalIndication.CLASS_2_EVENTS);
    }

    @CheckReturnValue
    public boolean hasClass3Events() {
        return this._getInternalIndication(InternalIndication.CLASS_3_EVENTS);
    }

    @CheckReturnValue
    public boolean hasConfigCorrupt() {
        return this._getInternalIndication(InternalIndication.CONFIG_CORRUPT);
    }

    @CheckReturnValue
    public boolean hasDeviceRestart() {
        return this._getInternalIndication(InternalIndication.DEVICE_RESTART);
    }

    @CheckReturnValue
    public boolean hasDeviceTrouble() {
        return this._getInternalIndication(InternalIndication.DEVICE_TROUBLE);
    }

    @CheckReturnValue
    public boolean hasEventBufferOverflow() {
        return this._getInternalIndication(InternalIndication.EVENT_BUFFER_OVERFLOW);
    }

    @CheckReturnValue
    public boolean hasLocalControl() {
        return this._getInternalIndication(InternalIndication.LOCAL_CONTROL);
    }

    @CheckReturnValue
    public boolean hasNeedTime() {
        return this._getInternalIndication(InternalIndication.NEED_TIME);
    }

    @CheckReturnValue
    public boolean hasNoFuncCodeSupport() {
        return this._getInternalIndication(InternalIndication.NO_FUNC_CODE_SUPPORT);
    }

    @CheckReturnValue
    public boolean hasObjectUnknown() {
        return this._getInternalIndication(InternalIndication.OBJECT_UNKNOWN);
    }

    @CheckReturnValue
    public boolean hasParameterError() {
        return this._getInternalIndication(InternalIndication.PARAMETER_ERROR);
    }

    public void set(@Nonnull InternalIndications internalIndications) {
        this._internalIndications = internalIndications.getInternalIndications();
    }

    public void set(@Nonnull InternalIndication internalIndication, boolean set) {
        this._internalIndications = set ? (short)(this._internalIndications | internalIndication.getMask()) : (short)(this._internalIndications & ~internalIndication.getMask());
    }

    public void setAlreadyExecuting(boolean state) {
        this._setInternalIndication(InternalIndication.ALREADY_EXECUTING, state);
    }

    public void setBroadcast(boolean state) {
        this._setInternalIndication(InternalIndication.BROADCAST, state);
    }

    public void setClass1Events(boolean state) {
        this._setInternalIndication(InternalIndication.CLASS_1_EVENTS, state);
    }

    public void setClass2Events(boolean state) {
        this._setInternalIndication(InternalIndication.CLASS_2_EVENTS, state);
    }

    public void setClass3Events(boolean state) {
        this._setInternalIndication(InternalIndication.CLASS_3_EVENTS, state);
    }

    public void setConfigCorrupt(boolean state) {
        this._setInternalIndication(InternalIndication.CONFIG_CORRUPT, state);
    }

    public void setDeviceRestart(boolean state) {
        this._setInternalIndication(InternalIndication.DEVICE_RESTART, state);
    }

    public void setDeviceTrouble(boolean state) {
        this._setInternalIndication(InternalIndication.DEVICE_TROUBLE, state);
    }

    public void setEventBufferOverflow(boolean state) {
        this._setInternalIndication(InternalIndication.EVENT_BUFFER_OVERFLOW, state);
    }

    public void setLocalControl(boolean state) {
        this._setInternalIndication(InternalIndication.LOCAL_CONTROL, state);
    }

    public void setNeedTime(boolean state) {
        this._setInternalIndication(InternalIndication.NEED_TIME, state);
    }

    public void setNoFuncCodeSupport(boolean state) {
        this._setInternalIndication(InternalIndication.NO_FUNC_CODE_SUPPORT, state);
    }

    public void setObjectUnknown(boolean state) {
        this._setInternalIndication(InternalIndication.OBJECT_UNKNOWN, state);
    }

    public void setParameterError(boolean state) {
        this._setInternalIndication(InternalIndication.PARAMETER_ERROR, state);
    }

    public String toString() {
        if (this._internalIndications == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < InternalIndication.getSize(); ++i) {
            if ((this._internalIndications & 1 << i) == 0) continue;
            builder.append(',');
            builder.append(InternalIndication.instance(i));
        }
        return builder.toString();
    }

    private boolean _getInternalIndication(InternalIndication internalIndication) {
        return (this._internalIndications & internalIndication.getMask()) != 0;
    }

    private void _setInternalIndication(InternalIndication internalIndication, boolean state) {
        int mask = internalIndication.getMask();
        this._internalIndications = state ? (short)(this._internalIndications | mask) : (short)(this._internalIndications & ~mask);
    }
}

