/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class LogicalDevice {
    private final Short _address;
    private _ServerManager _manager;
    private final String _name;

    public LogicalDevice(@Nonnull String name, @Nonnull Short address) {
        this._name = name;
        this._address = address;
    }

    @Nonnull
    @CheckReturnValue
    public Short getAddress() {
        return this._address;
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name + ':' + Integer.toHexString(this._address & 0xFFFF);
    }

    synchronized void activate(@Nonnull ConnectionManager connectionManager) {
        if (this._manager == null) {
            this._manager = new _ServerManager(connectionManager);
        }
    }

    synchronized void deactivate() {
        if (this._manager != null) {
            this._manager.close();
            this._manager = null;
        }
    }

    @CheckReturnValue
    boolean onFrameReceived(@Nonnull RemoteEndPoint remoteEndPoint, short remoteAddress) throws IOException {
        return this._manager != null ? this._manager.onFrameReceived(remoteEndPoint, remoteAddress) : false;
    }

    private class _ServerManager {
        private final ConnectionManager _connectionManager;
        private final Map<_ServerKey, _Server> _servers = new ConcurrentHashMap<_ServerKey, _Server>();

        _ServerManager(ConnectionManager connectionManager) {
            this._connectionManager = connectionManager;
        }

        @Nonnull
        @CheckReturnValue
        public ConnectionManager getConnectionManager() {
            return this._connectionManager;
        }

        void close() {
            Iterator<_Server> serverIterator = this._servers.values().iterator();
            while (serverIterator.hasNext()) {
                serverIterator.next().stop();
                serverIterator.remove();
            }
        }

        @CheckReturnValue
        boolean onFrameReceived(RemoteEndPoint remoteEndPoint, short remoteAddress) throws IOException {
            _ServerKey serverKey = new _ServerKey(remoteEndPoint, remoteAddress);
            if (!this._servers.containsKey(serverKey)) {
                _Server server = new _Server(remoteEndPoint, remoteAddress);
                this._servers.put(serverKey, server);
                server.start();
                this._connectionManager.onNewAssociation(server.getAssociation());
            }
            return true;
        }

        private class _Server
        implements ServiceThread.Target {
            private final Association _association;
            private final AtomicReference<ServiceThread> _thread = new AtomicReference();

            _Server(RemoteEndPoint remoteEndPoint, short remoteAddress) {
                this._association = remoteEndPoint.getAssociation(LogicalDevice.this.getAddress(), remoteAddress);
                this._thread.set(new ServiceThread((ServiceThread.Target)this, "Server thread for '" + LogicalDevice.this.toString() + "' < " + remoteEndPoint.getRemoteProxy() + " (" + Integer.toHexString(remoteAddress & 0xFFFF) + ")"));
            }

            public void run() throws Exception {
                _ServerManager.this.getConnectionManager().receiveMessages(this._association);
            }

            @Nonnull
            @CheckReturnValue
            Association getAssociation() {
                return this._association;
            }

            void start() {
                Thread thread = (Thread)this._thread.get();
                if (thread != null) {
                    thread.start();
                }
            }

            void stop() {
                ServiceThread thread = this._thread.getAndSet(null);
                if (thread != null) {
                    Logger logger = Logger.getInstance(this.getClass());
                    logger.debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                    Require.ignored((boolean)thread.interruptAndJoin(logger, 0L));
                }
            }
        }
    }

    private static class _ServerKey {
        private final short _remoteAddress;
        private final RemoteEndPoint _remoteEndPoint;

        _ServerKey(RemoteEndPoint remoteEndPoint, short remoteAddress) {
            this._remoteEndPoint = remoteEndPoint;
            this._remoteAddress = remoteAddress;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof _ServerKey) {
                _ServerKey other = (_ServerKey)object;
                return this._remoteAddress == other._remoteAddress && this._remoteEndPoint.equals(other._remoteEndPoint);
            }
            return false;
        }

        public int hashCode() {
            return this._remoteEndPoint.hashCode() ^ Short.hashCode(this._remoteAddress);
        }
    }
}

