/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.dnp3.DNP3OutstationProxy;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.ReadTransaction;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.pap.dnp3.transport.WriteTransaction;

public final class MasterOutstationAssociation
extends Association {
    private byte _latestRequestSequenceSent;
    private Fragment _latestSolicitedResponseFragment;
    private Fragment _latestUnsolicitedResponseFragment;
    private final ReadTransaction _readTransaction;
    private boolean _unsolicitedSupported;
    private final WriteTransaction _writeTransaction;

    public MasterOutstationAssociation(short localDeviceAddress, short remoteDeviceAddress, @Nonnull RemoteEndPoint remoteEndPoint) {
        super(localDeviceAddress, remoteDeviceAddress, remoteEndPoint);
        DNP3OutstationProxy outstationProxy = (DNP3OutstationProxy)remoteEndPoint.getRemoteProxy();
        this._readTransaction = new ReadTransaction(outstationProxy);
        this._writeTransaction = new WriteTransaction(outstationProxy);
    }

    @Nonnull
    @CheckReturnValue
    public ReadTransaction.Request addReadRequest(@Nonnull Point point) {
        return this._readTransaction.addRequest(point);
    }

    @Nonnull
    @CheckReturnValue
    public WriteTransaction.Request addWriteRequest(@Nonnull PointValue pointValue) {
        return this._writeTransaction.addRequest(pointValue);
    }

    @Nonnull
    @CheckReturnValue
    public ReadTransaction.Response[] commitReadRequests() throws ServiceNotAvailableException {
        try {
            return this._readTransaction.commit();
        }
        catch (ServiceNotAvailableException exception) {
            this.disconnect();
            throw exception;
        }
    }

    @Nonnull
    @CheckReturnValue
    public WriteTransaction.Response[] commitWriteRequests() throws ServiceNotAvailableException {
        try {
            return this._writeTransaction.commit();
        }
        catch (ServiceNotAvailableException exception) {
            this.disconnect();
            throw exception;
        }
    }

    public void disconnect() {
        this.getRemoteEndPoint().close();
    }

    @CheckReturnValue
    public byte getLatestRequestSequenceSent() {
        return this._latestRequestSequenceSent;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Fragment> getLatestSolicitedResponseFragment() {
        return Optional.ofNullable(this._latestSolicitedResponseFragment);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Fragment> getLatestUnsolicitedResponseFragment() {
        return Optional.ofNullable(this._latestUnsolicitedResponseFragment);
    }

    @CheckReturnValue
    public boolean isUnsolicitedSupported() {
        return this._unsolicitedSupported;
    }

    @Override
    public boolean isWithOutstation() {
        return true;
    }

    public void rollbackReadRequests() {
        this._readTransaction.rollback();
    }

    public void rollbackWriteRequests() {
        this._writeTransaction.rollback();
    }

    public void setLatestRequestSequenceSent(byte latestRequestSequenceSent) {
        this._latestRequestSequenceSent = latestRequestSequenceSent;
    }

    public void setLatestSolicitedResponseFragment(@Nonnull Fragment latestSolicitedResponseFragment) {
        this._latestSolicitedResponseFragment = Objects.requireNonNull(latestSolicitedResponseFragment);
    }

    public void setLatestUnsolicitedResponseFragment(@Nonnull Fragment latestUnsolicitedResponseFragment) {
        this._latestUnsolicitedResponseFragment = Objects.requireNonNull(latestUnsolicitedResponseFragment);
    }

    public void setUnsolicitedSupported(boolean unsolicitedSupported) {
        this._unsolicitedSupported = unsolicitedSupported;
    }
}

