/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3Proxy;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.DataLinkLayer;
import org.rvpf.pap.dnp3.transport.EndPoint;
import org.rvpf.pap.dnp3.transport.Frame;
import org.rvpf.pap.dnp3.transport.MasterOutstationAssociation;
import org.rvpf.pap.dnp3.transport.OutstationMasterAssociation;

public class RemoteEndPoint
extends EndPoint {
    private final Map<Integer, Association> _associations = new ConcurrentHashMap<Integer, Association>();
    private final DNP3Proxy _remoteProxy;

    public RemoteEndPoint(@Nonnull ConnectionManager connectionManager, @Nonnull DNP3Proxy remoteProxy) {
        super(connectionManager);
        this._remoteProxy = remoteProxy;
    }

    @Override
    public final void close() {
        for (Association association : this._associations.values()) {
            association.close();
        }
        this._associations.clear();
        super.close();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getRemoteProxyName().equals(((RemoteEndPoint)object).getRemoteProxyName());
    }

    @Nonnull
    @CheckReturnValue
    public final Association getAssociation(@Nonnull short localDeviceAddress, @Nonnull short remoteDeviceAddress) {
        Integer associationKey = localDeviceAddress << 16 | remoteDeviceAddress & 0xFFFF;
        Association association = this._associations.get(associationKey);
        if (association == null) {
            if (this.isOnMaster()) {
                association = new MasterOutstationAssociation(localDeviceAddress, remoteDeviceAddress, this);
            } else if (this.isOnOutstation()) {
                association = new OutstationMasterAssociation(localDeviceAddress, remoteDeviceAddress, this);
            } else {
                throw Require.failure();
            }
            this._associations.put(associationKey, association);
        }
        return association;
    }

    @CheckReturnValue
    public final int getConnectTimeout() {
        return this._remoteProxy.getConnectTimeout();
    }

    @Nullable
    @CheckReturnValue
    public Connection getConnection() {
        return this.getConnectionManager().getConnection(this);
    }

    @CheckReturnValue
    public final int getMaxFragmentSize() {
        return this._remoteProxy.getMaxFragmentSize();
    }

    @Nonnull
    @CheckReturnValue
    public final DNP3Proxy getRemoteProxy() {
        return this._remoteProxy;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getRemoteProxyName() {
        return this._remoteProxy.getName();
    }

    @CheckReturnValue
    public final long getReplyTimeout() {
        return this._remoteProxy.getReplyTimeout();
    }

    @Nonnull
    @CheckReturnValue
    public final String getSerialPortName() {
        return this._remoteProxy.getSerialPortName();
    }

    @CheckReturnValue
    public final int getSerialPortSpeed() {
        return this._remoteProxy.getSerialPortSpeed();
    }

    @Nonnull
    @CheckReturnValue
    public final List<InetSocketAddress> getTCPSocketAddresses() {
        return this._remoteProxy.getTCPSocketAddresses();
    }

    @Nonnull
    @CheckReturnValue
    public final List<InetSocketAddress> getUDPSocketAddresses() {
        return this._remoteProxy.getUDPSocketAddresses();
    }

    public final int hashCode() {
        return this.getRemoteProxyName().hashCode();
    }

    public void onFrameReceived(@Nonnull Frame frame) throws IOException {
        if (this.getConnectionManager().onFrameReceived(frame, this)) {
            Frame.Header frameHeader = frame.getHeader();
            Association association = this.getAssociation(frameHeader.getDestination(), frameHeader.getSource());
            DataLinkLayer dataLinkLayer = association.getDataLinkLayer();
            dataLinkLayer.accept(frame);
        } else if (this.getThisLogger().isTraceEnabled()) {
            Frame.Header frameHeader = frame.getHeader();
            this.getThisLogger().trace((Messages.Entry)DNP3Messages.IGNORED_FRAME, new Object[]{frameHeader.getFunctionCode(), this._remoteProxy, Integer.toHexString(frameHeader.getSource() & 0xFFFF), Integer.toHexString(frameHeader.getDestination() & 0xFFFF)});
        }
    }
}

