/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

final class TCPSocketListener
implements ServiceThread.Target {
    private static final Logger _LOGGER = Logger.getInstance(TCPSocketListener.class);
    private final ConnectionManager _connectionManager;
    private final InetSocketAddress _listenAddress;
    private ServerSocketChannel _serverSocketChannel;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    TCPSocketListener(@Nonnull InetSocketAddress listenAddress, @Nonnull ConnectionManager connectionManager) {
        this._listenAddress = listenAddress;
        this._connectionManager = connectionManager;
    }

    public void run() throws IOException {
        try {
            while (true) {
                this._connectionManager.onSocketAccepted(this._serverSocketChannel.accept());
            }
        }
        catch (ClosedChannelException exception) {
            return;
        }
    }

    void start() throws IOException {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "DNP3 " + (this._connectionManager.isOnMaster() ? "master" : "outstation") + " TCP socket listener on " + this._listenAddress);
        if (this._thread.compareAndSet(null, thread)) {
            this._serverSocketChannel = ServerSocketChannel.open();
            this._serverSocketChannel.bind(this._listenAddress);
            _LOGGER.debug((Messages.Entry)DNP3Messages.STARTED_LISTENING, new Object[]{this._listenAddress});
            _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    void stop() throws IOException {
        Thread thread = this._thread.getAndSet(null);
        if (thread != null) {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            try {
                this._serverSocketChannel.close();
                thread.join();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException exception) {
                throw (IOException)new InterruptedIOException().initCause(exception);
            }
        }
        _LOGGER.debug((Messages.Entry)DNP3Messages.STOPPED_LISTENING, new Object[]{this._listenAddress});
    }
}

