/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.transport.Association;

public final class TransportFunction {
    public static final int MAXIMUM_SEGMENT_SIZE = 250;
    private static final int _FIN_MASK = 128;
    private static final int _FIR_MASK = 64;
    private static final int _SEQUENCE_MASK = 63;
    private final Association _association;
    private final ByteBuffer _inputSegment = ByteBuffer.allocate(250);
    private int _inputSequence;
    private final ByteBuffer _outputSegment = ByteBuffer.allocate(250);
    private int _outputSequence;

    public TransportFunction(@Nonnull Association association) {
        this._association = association;
        this._inputSegment.order(ByteOrder.LITTLE_ENDIAN);
        this._outputSegment.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void receive(@Nonnull ByteBuffer fragmentBuffer) throws IOException {
        byte header;
        boolean first = true;
        do {
            this._inputSegment.clear();
            this._association.getDataLinkLayer().receive(this._inputSegment);
            this._inputSegment.flip();
            header = this._inputSegment.get();
            if ((header & 0x40) != (first ? 64 : 0)) {
                throw new DNP3ProtocolException(DNP3Messages.INVERTED_FIR_BIT, new Object[0]);
            }
            if (first) {
                this._inputSequence = header & 0x3F;
                first = false;
            } else if ((header & 0x3F) != (++this._inputSequence & 0x3F)) {
                throw new DNP3ProtocolException(DNP3Messages.UNEXPECTED_SEGMENT_SEQUENCE, String.valueOf(this._inputSequence), String.valueOf(header & 0x3F));
            }
            try {
                while (this._inputSegment.hasRemaining()) {
                    fragmentBuffer.put(this._inputSegment.get());
                }
            }
            catch (BufferOverflowException exception) {
                throw new DNP3ProtocolException(DNP3Messages.FRAGMENT_BUFFER_OVERFLOW, new Object[0]);
            }
        } while ((header & 0x80) == 0);
    }

    public void send(@Nonnull ByteBuffer fragmentBuffer) throws IOException {
        int header = 64;
        while (fragmentBuffer.hasRemaining()) {
            this._outputSegment.clear();
            if (fragmentBuffer.remaining() < this._outputSegment.capacity()) {
                header |= 0x80;
            }
            header &= 0xFFFFFFC0;
            this._outputSegment.put((byte)(header |= this._outputSequence++ & 0x3F));
            do {
                this._outputSegment.put(fragmentBuffer.get());
            } while (fragmentBuffer.hasRemaining() && this._outputSegment.hasRemaining());
            this._outputSegment.flip();
            this._association.getDataLinkLayer().send(this._outputSegment);
        }
    }
}

