/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public class UDPDatagramListener
implements ServiceThread.Target {
    public static final int MAXIMUM_DATAGRAM_SIZE = 512;
    private static final Logger _LOGGER = Logger.getInstance(UDPDatagramListener.class);
    private final ConnectionManager _connectionManager;
    private volatile DatagramChannel _datagramChannel;
    private final InetSocketAddress _listenAddress;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    public UDPDatagramListener(@Nonnull InetSocketAddress listenAddress, @Nonnull ConnectionManager connectionManager) {
        this._listenAddress = listenAddress;
        this._connectionManager = connectionManager;
    }

    public void run() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(512);
        while (true) {
            InetSocketAddress sourceAddress;
            try {
                sourceAddress = (InetSocketAddress)this._datagramChannel.receive(buffer);
            }
            catch (ClosedChannelException exception) {
                break;
            }
            buffer.flip();
            this._connectionManager.onDatagramReceived(sourceAddress, buffer);
            buffer.clear();
        }
    }

    @Nonnull
    @CheckReturnValue
    DatagramChannel getChannel() {
        return (DatagramChannel)Require.notNull((Object)this._datagramChannel);
    }

    void start() throws IOException {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "DNP3 " + (this._connectionManager.isOnMaster() ? "master" : "outstation") + " UDP datagram listener on " + this._listenAddress);
        if (this._thread.compareAndSet(null, thread)) {
            this._datagramChannel = DatagramChannel.open(StandardProtocolFamily.INET);
            this._datagramChannel.bind(this._listenAddress);
            _LOGGER.debug((Messages.Entry)DNP3Messages.STARTED_LISTENING, new Object[]{this._listenAddress});
            _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    void stop() throws IOException {
        Thread thread = this._thread.getAndSet(null);
        if (thread != null) {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            try {
                this._datagramChannel.close();
                thread.join();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            catch (InterruptedException exception) {
                throw (IOException)new InterruptedIOException().initCause(exception);
            }
        }
        _LOGGER.debug((Messages.Entry)DNP3Messages.STOPPED_LISTENING, new Object[]{this._listenAddress});
    }
}

