/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.transport;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPTransaction;
import org.rvpf.pap.dnp3.DNP3OutstationProxy;
import org.rvpf.pap.dnp3.transport.Transaction;

public final class WriteTransaction
extends Transaction {
    private final Collection<Request> _requests = new LinkedList<Request>();
    private final Collection<Response> _responses = new LinkedList<Response>();

    WriteTransaction(@Nonnull DNP3OutstationProxy outstationProxy) {
        super(outstationProxy);
    }

    @Nonnull
    Request addRequest(@Nonnull PointValue pointValue) {
        Request request = new Request(pointValue);
        this._requests.add(request);
        return request;
    }

    void addResponse(@Nonnull Request request, boolean success) {
        this._responses.add(new Response(request, success));
    }

    @Nonnull
    @CheckReturnValue
    Response[] commit() throws ServiceNotAvailableException {
        Response[] responses = this._responses.toArray(new Response[this._responses.size()]);
        this.rollback();
        return responses;
    }

    @Nonnull
    @CheckReturnValue
    Collection<Request> getRequests() {
        return this._requests;
    }

    @CheckReturnValue
    boolean isEmpty() {
        return this._requests.isEmpty();
    }

    void rollback() {
        this._requests.clear();
        this._responses.clear();
    }

    public final class Response
    extends Transaction.Response
    implements PAPTransaction.Response {
        private final boolean _success;

        Response(Request request, boolean success) {
            super(request);
            this._success = success;
        }

        @Override
        public boolean isSuccess() {
            return this._success && !WriteTransaction.this.getException().isPresent();
        }
    }

    public final class Request
    extends Transaction.Request
    implements PAPTransaction.Request {
        private final PointValue _pointValue;

        Request(PointValue pointValue) {
            this._pointValue = pointValue;
        }

        @Nonnull
        @CheckReturnValue
        public PointValue getPointValue() {
            return this._pointValue;
        }

        @Override
        public Optional<? extends PAPTransaction.Response> getResponse() throws InterruptedException {
            return Optional.empty();
        }

        @Override
        public boolean waitForResponse() throws InterruptedException {
            return false;
        }
    }
}

