/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.server.pap.dnp3;

import java.util.Optional;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.pap.dnp3.DNP3OutstationContext;
import org.rvpf.pap.dnp3.DNP3Support;
import org.rvpf.store.server.StoreServiceAppImpl;
import org.rvpf.store.server.pap.PAPUpdatesListener;

public final class DNP3UpdatesListener
extends PAPUpdatesListener {
    private String[] _originNames;
    private volatile DNP3Outstation _outstation;

    public void onMetadataRefreshed(Metadata metadata) {
        DNP3Outstation outstation;
        super.onMetadataRefreshed(metadata);
        DNP3Support support = new DNP3Support();
        DNP3OutstationContext outstationContext = support.newOutstationContext(metadata, this._originNames, Optional.empty());
        DNP3Outstation dNP3Outstation = outstation = outstationContext != null ? support.newOutstation(outstationContext) : null;
        if (outstation != null) {
            this._outstation = outstation;
        }
    }

    @Override
    public boolean setUp(StoreServiceAppImpl storeAppImpl, KeyedGroups updatesListenerProperties) {
        if (!super.setUp(storeAppImpl, updatesListenerProperties)) {
            return false;
        }
        KeyedGroups dnp3Properties = updatesListenerProperties.getGroup("dnp3");
        this._originNames = dnp3Properties.getStrings("origin");
        DNP3Support support = new DNP3Support();
        DNP3OutstationContext outstationContext = support.newOutstationContext(storeAppImpl.getMetadata(), this._originNames, Optional.empty());
        DNP3Outstation dNP3Outstation = this._outstation = outstationContext != null ? support.newOutstation(outstationContext) : null;
        if (this._outstation == null || !this._outstation.setUp(dnp3Properties)) {
            return false;
        }
        this._outstation.setResponder(this);
        return true;
    }

    protected void doCommit() throws InterruptedException {
        this._outstation.onUpdatesCommit();
    }

    protected void doStart() throws InterruptedException {
        DNP3Outstation outstation = this._outstation;
        if (outstation != null) {
            super.doStart();
            this._outstation.start();
        }
    }

    protected void doStop() {
        DNP3Outstation outstation = this._outstation;
        if (outstation != null) {
            outstation.stop();
        }
    }

    protected Optional<PointValue> nextUpdate(int limit, boolean wait) throws InterruptedException {
        DNP3Outstation outstation = this._outstation;
        if (outstation == null) {
            throw new InterruptedException();
        }
        Optional<PointValue> pointValue = this._outstation.nextUpdate(wait ? -1L : 0L);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return pointValue;
    }
}

