/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.forwarder.input.pap.dnp3;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.forwarder.ForwarderServiceActivator;
import org.rvpf.pap.dnp3.DNP3Master;
import org.rvpf.service.ServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.dnp3.DNP3Tests;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class ForwarderInputTests
extends MetadataServiceTests {
    private static final String _DNP3_FORWARDER_NAME = "DNP3";
    private static final String _FORWARDER_QUEUE_PROPERTIES = "tests.forwarder.queue";
    private static final String _TESTS_PROPERTIES = "rvpf-dnp3.properties";
    private ServiceActivator _forwarderService;
    private MessagingSupport.Receiver _receiver;
    private DNP3TestsSupport _support;

    @BeforeClass
    public void setUp() throws Exception {
        DNP3TestsSupport.setPortProperties();
        ForwarderInputTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this.setUpAlerter();
        this._support = new DNP3TestsSupport(Optional.of(this.getMetadata()));
        this._forwarderService = this.startService(ForwarderServiceActivator.class, Optional.of(_DNP3_FORWARDER_NAME));
        this._receiver = this.getMessaging().createClientReceiver(this.getConfig().getPropertiesGroup(_FORWARDER_QUEUE_PROPERTIES));
        this._receiver.purge();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._receiver.commit();
        this._receiver.purge();
        this._receiver.close();
        this._receiver = null;
        this.stopService(this._forwarderService);
        this._forwarderService = null;
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        _Tests tests = new _Tests(this._support, this._receiver, this.getTimeout(), this);
        DNP3Master master = this._support.getMaster();
        master.open();
        Require.success((boolean)master.connect(this._support.getOutstationOrigin(), (short)4));
        tests.test();
        master.disconnect(this._support.getOutstationOrigin());
    }

    private static final class _Tests
    extends DNP3Tests {
        private final MessagingSupport.Receiver _receiver;
        private final int _timeout;

        _Tests(@Nonnull DNP3TestsSupport suppport, @Nonnull MessagingSupport.Receiver receiver, int timeout, @Nonnull ForwarderInputTests owner) {
            super(suppport, (Tests)owner);
            this._receiver = receiver;
            this._timeout = timeout;
        }

        @Override
        protected Optional<PointValue> getNextPointValue() {
            try {
                return Optional.ofNullable((PointValue)this._receiver.receive((long)this._timeout));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        protected boolean isWriteOnly() {
            return true;
        }

        @Override
        protected void putPointValue(PointValue pointValue) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

