/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.cip;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.cip.CIPClient;
import org.rvpf.pap.cip.CIPSupport;
import org.rvpf.pap.cip.transport.ReadTransaction;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CIPClientTests
extends MetadataServiceTests
implements PAPConnectionListener {
    private static final String _TESTS_BOOL_1_POINT = "TESTS-CIP.BOOL.1";
    private static final String _TESTS_BOOL_ARRAY_1_POINT = "TESTS-CIP.BOOL.ARRAY.1";
    private static final String _TESTS_DINT_1_POINT = "TESTS-CIP.DINT.1";
    private static final String _TESTS_DINT_ARRAY_1_POINT = "TESTS-CIP.DINT.ARRAY.1";
    private static final String _TESTS_INT_1_POINT = "TESTS-CIP.INT.1";
    private static final String _TESTS_ORIGIN_NAME = "TestsCIP";
    private static final String _TESTS_PROPERTIES = "rvpf-cip.properties";
    private static final String _TESTS_REAL_1_POINT = "TESTS-CIP.REAL.1";
    private static final String _TESTS_REAL_ARRAY_1_POINT = "TESTS-CIP.REAL.ARRAY.1";
    private static final String _TESTS_SINT_1_POINT = "TESTS-CIP.SINT.1";
    private CIPClient _client;
    private boolean _connected;
    private boolean _disconnected;
    private Origin _origin;

    public boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
        Require.failure((boolean)this._disconnected);
        this._disconnected = true;
        return true;
    }

    public boolean onNewConnection(PAPProxy remoteProxy) {
        Require.failure((boolean)this._connected);
        this._connected = true;
        return true;
    }

    @BeforeClass
    public void setUp() {
        CIPClientTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        CIPSupport support = new CIPSupport();
        this._client = support.newClient((PAPContext)support.newClientContext(this.getMetadata(true), Optional.empty()));
        this._origin = (Origin)this._client.getOrigin(Optional.of(_TESTS_ORIGIN_NAME)).get();
    }

    @Test
    public void test() throws Exception {
        int i;
        this._client.open();
        Require.success((boolean)this._client.addConnectionListener((PAPConnectionListener)this));
        Require.failure((boolean)this._connected);
        Require.success((boolean)this._client.connect(this._origin));
        Require.success((boolean)this._connected);
        Metadata metadata = this.getMetadata();
        Point pointBOOL1 = (Point)metadata.getPoint(_TESTS_BOOL_1_POINT).get();
        Point pointDINT1 = (Point)metadata.getPoint(_TESTS_DINT_1_POINT).get();
        Point pointBOOLArray1 = (Point)metadata.getPoint(_TESTS_BOOL_ARRAY_1_POINT).get();
        Point pointDINTArray1 = (Point)metadata.getPoint(_TESTS_DINT_ARRAY_1_POINT).get();
        Point pointREALArray1 = (Point)metadata.getPoint(_TESTS_REAL_ARRAY_1_POINT).get();
        Point pointINT1 = (Point)metadata.getPoint(_TESTS_INT_1_POINT).get();
        Point pointREAL1 = (Point)metadata.getPoint(_TESTS_REAL_1_POINT).get();
        Point pointSINT1 = (Point)metadata.getPoint(_TESTS_SINT_1_POINT).get();
        Tuple boolTuple = new Tuple();
        Tuple dintTuple = new Tuple();
        Tuple realTuple = new Tuple();
        Require.notNull((Object)pointBOOL1);
        Require.notNull((Object)pointDINT1);
        Require.notNull((Object)pointBOOLArray1);
        Require.notNull((Object)pointDINTArray1);
        Require.notNull((Object)pointREALArray1);
        Require.notNull((Object)pointINT1);
        Require.notNull((Object)pointREAL1);
        Require.notNull((Object)pointSINT1);
        Attributes attributes = (Attributes)pointDINTArray1.getAttributes("CIP").get();
        int elements = attributes.getInt("ELEMENTS", 0);
        for (i = 0; i < elements; ++i) {
            boolTuple.add((Serializable)Boolean.valueOf((i & 1) != 0));
        }
        for (i = 0; i < elements; ++i) {
            dintTuple.add((Serializable)Integer.valueOf(i));
        }
        for (i = 0; i < elements; ++i) {
            realTuple.add((Serializable)Float.valueOf((float)((double)i / 10.0)));
        }
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointBOOL1, Optional.empty(), null, (Serializable)Boolean.valueOf(true))));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointDINT1, Optional.empty(), null, (Serializable)Integer.valueOf(1234))));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointBOOLArray1, Optional.empty(), null, (Serializable)boolTuple)));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointDINTArray1, Optional.empty(), null, (Serializable)dintTuple)));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointREALArray1, Optional.empty(), null, (Serializable)realTuple)));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointINT1, Optional.empty(), null, (Serializable)Short.valueOf((short)123))));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointREAL1, Optional.empty(), null, (Serializable)Float.valueOf(12.34f))));
        Require.present((Optional)this._client.requestPointUpdate(new PointValue(pointSINT1, Optional.empty(), null, (Serializable)Byte.valueOf((byte)12))));
        Require.ignored((Object)this._client.commitPointUpdateRequests());
        Require.notNull((Object)this._client.requestPointValue(pointBOOL1));
        Require.notNull((Object)this._client.requestPointValue(pointDINT1));
        Require.notNull((Object)this._client.requestPointValue(pointBOOLArray1));
        Require.notNull((Object)this._client.requestPointValue(pointDINTArray1));
        Require.notNull((Object)this._client.requestPointValue(pointREALArray1));
        Require.notNull((Object)this._client.requestPointValue(pointINT1));
        Require.notNull((Object)this._client.requestPointValue(pointREAL1));
        Require.notNull((Object)this._client.requestPointValue(pointSINT1));
        Collection responses = (Collection)Require.notNull((Object)this._client.commitPointValueRequests());
        Require.equal((long)8L, (long)responses.size());
        Iterator iterator = responses.iterator();
        PointValue pointBOOL1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointDINT1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointBOOLArray1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointDINTArray1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointREALArray1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointINT1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointREAL1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        PointValue pointSINT1Value = (PointValue)((ReadTransaction.Response)iterator.next()).getPointValue().get();
        Require.equal((Object)pointBOOL1Value.getValue(), (Object)true);
        Require.equal((Object)pointDINT1Value.getValue(), (Object)1234);
        Require.equal((Object)pointBOOLArray1Value.getValue(), (Object)boolTuple);
        Require.equal((Object)pointDINTArray1Value.getValue(), (Object)dintTuple);
        Require.equal((Object)pointREALArray1Value.getValue(), (Object)realTuple);
        Require.equal((Object)pointINT1Value.getValue(), (Object)123);
        Require.equal((Object)pointREAL1Value.getValue(), (Object)Float.valueOf(12.34f));
        Require.equal((Object)pointSINT1Value.getValue(), (Object)12);
        Require.failure((boolean)this._disconnected);
        this._client.disconnect();
        Require.success((boolean)this._disconnected);
        Require.success((boolean)this._client.removeConnectionListener((PAPConnectionListener)this));
        this._client.close();
    }
}

