/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.cip;

import java.io.IOException;
import java.net.Socket;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.config.Config;
import org.rvpf.document.loader.ConfigDocumentLoader;
import org.rvpf.tests.service.ServiceTests;
import org.testng.annotations.Factory;
import org.testng.annotations.Parameters;

public final class CIPTestsFactory
extends ServiceTests {
    private static final String _TESTS_PROPERTIES = "rvpf-cip.properties";
    private static final String _TESTS_SERVER_ADDRESS_PROPERTY = "tests.cip.tcp.address";
    private static Boolean _serverAvailable;

    private CIPTestsFactory() {
    }

    @Factory
    @Parameters(value={"tests"})
    public static Object[] createTests(@Nonnull String tests) {
        Object testsInstance;
        if (_serverAvailable == null) {
            Config config;
            CIPTestsFactory.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
            try {
                config = ConfigDocumentLoader.loadConfig((String)"", Optional.empty(), Optional.empty());
            }
            finally {
                CIPTestsFactory.clearSystemProperty((String)"rvpf.properties");
            }
            if (config != null) {
                Optional testsServerHost = config.getStringValue(_TESTS_SERVER_ADDRESS_PROPERTY);
                if (testsServerHost.isPresent()) {
                    try {
                        Socket socket = new Socket((String)testsServerHost.get(), 44818);
                        socket.close();
                        _serverAvailable = Boolean.TRUE;
                    }
                    catch (IOException exception) {
                        _serverAvailable = Boolean.FALSE;
                    }
                } else {
                    _serverAvailable = Boolean.FALSE;
                }
            } else {
                _serverAvailable = Boolean.FALSE;
            }
        }
        if (!_serverAvailable.booleanValue()) {
            return new Object[0];
        }
        try {
            testsInstance = Class.forName(tests).newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(tests, exception);
        }
        return new Object[]{testsInstance};
    }
}

