/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.service.ServiceThread;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.dnp3.DNP3TestsMessages;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;

public abstract class DNP3ConnectionsTests
extends Tests
implements ServiceThread.Target {
    private static final int _MESSAGE_COUNT = 100;
    private Connection _serverConnection;
    private DNP3TestsSupport _support;

    public final void run() {
        ByteBuffer buffer = ByteBuffer.allocate(292);
        try {
            while (true) {
                byte[] message = this._readMessage(this._serverConnection, buffer);
                buffer.clear();
                buffer.putShort((short)message.length);
                buffer.put(message);
                buffer.flip();
                this._serverConnection.send(buffer);
            }
        }
        catch (ClosedChannelException exception) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void test() throws Exception {
        Connection clientConnection = this.newMasterConnection();
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.MASTER_CONNECTION, new Object[]{clientConnection});
        this._serverConnection = this.newOutstationConnection();
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.OUTSTATION_CONNECTION, new Object[]{this._serverConnection});
        new ServiceThread((ServiceThread.Target)this, "Connections tests").start();
        ByteBuffer buffer = ByteBuffer.allocate(292);
        Random random = new Random();
        for (int i = 1; i <= 100; ++i) {
            int frameSize = 10 + random.nextInt(282);
            byte[] sentMessage = new byte[frameSize - 2];
            random.nextBytes(sentMessage);
            buffer.clear();
            buffer.putShort((short)sentMessage.length);
            buffer.put(sentMessage);
            buffer.flip();
            clientConnection.send(buffer);
            byte[] receivedMessage = this._readMessage(clientConnection, buffer);
            Require.equal((long)sentMessage.length, (long)receivedMessage.length);
            Require.success((boolean)Arrays.equals(receivedMessage, sentMessage));
        }
        clientConnection.close();
        this._serverConnection.close();
    }

    @Nonnull
    @CheckReturnValue
    protected DNP3TestsSupport getSupport() {
        if (this._support == null) {
            this._support = new DNP3TestsSupport(Optional.empty());
        }
        return this._support;
    }

    @Nonnull
    @CheckReturnValue
    protected abstract Connection newMasterConnection() throws Exception;

    @Nonnull
    @CheckReturnValue
    protected abstract Connection newOutstationConnection() throws Exception;

    protected void receive(@Nonnull Connection connection, @Nonnull ByteBuffer buffer) throws Exception {
        connection.receive(buffer);
    }

    private byte[] _readMessage(Connection connection, ByteBuffer buffer) throws Exception {
        buffer.clear();
        do {
            this.receive(connection, buffer);
        } while (buffer.position() < 2);
        buffer.flip();
        int messageSize = buffer.getShort();
        int frameSize = 2 + messageSize;
        Require.success((frameSize >= 10 ? 1 : 0) != 0);
        Require.success((frameSize <= 292 ? 1 : 0) != 0);
        byte[] message = new byte[messageSize];
        for (int i = 0; i < messageSize; ++i) {
            if (!buffer.hasRemaining()) {
                buffer.clear();
                this.receive(connection, buffer);
                buffer.flip();
            }
            message[i] = buffer.get();
        }
        return message;
    }
}

