/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.DataLinkLayer;
import org.rvpf.service.ServiceThread;
import org.rvpf.tests.pap.dnp3.DNP3TestsMessages;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DNP3DataLinkLayerTests
extends MetadataServiceTests
implements ServiceThread.Target {
    public static final int DEFAULT_MESSAGE_COUNT = 100;
    public static final String MESSAGE_COUNT_PROPERTY = "tests.dataLink.messages";
    private static final String _TESTS_PROPERTIES = "rvpf-dnp3.properties";
    private int _messageCount;
    private DataLinkLayer _outstationDataLink;
    private ServerSocketChannel _outstationSocketChannel;
    private final InetSocketAddress _tcpSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), DNP3DataLinkLayerTests.allocateTCPPort());

    public DNP3DataLinkLayerTests() throws Exception {
        this._outstationSocketChannel = ServerSocketChannel.open();
        this._outstationSocketChannel.bind(this._tcpSocketAddress);
    }

    public final void run() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(250);
        try {
            Require.success((boolean)this._outstationDataLink.isLinkActive((long)this.getTimeout(DEFAULT_TIMEOUT)));
            Thread.sleep(1L);
        }
        catch (IOException | InterruptedException exception) {
            throw new RuntimeException(exception);
        }
        try {
            while (true) {
                byte[] message = DNP3DataLinkLayerTests._readMessage(this._outstationDataLink, buffer);
                Thread.sleep(1L);
                buffer.clear();
                buffer.putShort((short)message.length);
                buffer.put(message);
                buffer.flip();
                this._outstationDataLink.send(buffer);
                Thread.sleep(1L);
            }
        }
        catch (ClosedChannelException exception) {
            return;
        }
    }

    @BeforeClass
    public void setUp() {
        DNP3DataLinkLayerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this._messageCount = this.getConfig().getIntValue(MESSAGE_COUNT_PROPERTY, 100);
    }

    @Test
    public final void test() throws Exception {
        DNP3DataLinkLayerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        DNP3TestsSupport support = new DNP3TestsSupport(Optional.of(this.getMetadata()));
        Connection masterConnection = support.newTCPConnection(true, SocketChannel.open(this._tcpSocketAddress));
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.MASTER_CONNECTION, new Object[]{masterConnection});
        Connection outstationConnection = support.newTCPConnection(false, this._outstationSocketChannel.accept());
        this.getThisLogger().debug((Messages.Entry)DNP3TestsMessages.OUTSTATION_CONNECTION, new Object[]{outstationConnection});
        outstationConnection.activate();
        masterConnection.activate();
        Association outstationMasterAssociation = outstationConnection.getRemoteEndPoint().getAssociation((short)0, (short)0);
        this._outstationDataLink = outstationMasterAssociation.getDataLinkLayer();
        Association masterOutstationAssociation = masterConnection.getRemoteEndPoint().getAssociation((short)0, (short)0);
        DataLinkLayer masterDataLink = masterOutstationAssociation.getDataLinkLayer();
        ServiceThread serviceThread = new ServiceThread((ServiceThread.Target)this, "Data link tests");
        serviceThread.start();
        ByteBuffer buffer = ByteBuffer.allocate(250);
        Random random = new Random();
        Require.success((boolean)masterDataLink.isLinkActive((long)this.getTimeout(DEFAULT_TIMEOUT)));
        for (int i = 1; i <= this._messageCount; ++i) {
            int segmentSize = 2 + random.nextInt(248);
            byte[] sentMessage = new byte[segmentSize - 2];
            random.nextBytes(sentMessage);
            buffer.clear();
            buffer.putShort((short)sentMessage.length);
            buffer.put(sentMessage);
            buffer.flip();
            masterDataLink.send(buffer);
            Thread.sleep(1L);
            byte[] receivedMessage = DNP3DataLinkLayerTests._readMessage(masterDataLink, buffer);
            Require.equal((long)sentMessage.length, (long)receivedMessage.length);
            Require.success((boolean)Arrays.equals(receivedMessage, sentMessage));
            Thread.sleep(1L);
        }
        Require.success((boolean)masterDataLink.isLinkActive((long)this.getTimeout(DEFAULT_TIMEOUT)));
        Thread.sleep(1L);
        Require.success((boolean)masterDataLink.isLinkActive((long)this.getTimeout(DEFAULT_TIMEOUT)));
        masterConnection.close();
        outstationConnection.close();
        Require.ignored((boolean)serviceThread.interruptAndJoin(this.getThisLogger(), (long)this.getTimeout(DEFAULT_TIMEOUT)));
    }

    private static byte[] _readMessage(DataLinkLayer dataLink, ByteBuffer buffer) throws Exception {
        buffer.clear();
        do {
            dataLink.receive(buffer);
        } while (buffer.position() < 2);
        buffer.flip();
        int messageSize = buffer.getShort();
        int segmentSize = 2 + messageSize;
        Require.success((segmentSize >= 1 ? 1 : 0) != 0);
        Require.success((segmentSize <= 250 ? 1 : 0) != 0);
        byte[] message = new byte[messageSize];
        for (int i = 0; i < messageSize; ++i) {
            if (!buffer.hasRemaining()) {
                buffer.clear();
                dataLink.receive(buffer);
                buffer.flip();
            }
            message[i] = buffer.get();
        }
        return message;
    }
}

