/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3Master;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.dnp3.DNP3Tests;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class DNP3MasterOutstationTests
extends MetadataServiceTests
implements PAPProxy.Responder,
PAPConnectionListener {
    private static final String _TESTS_PROPERTIES = "rvpf-dnp3.properties";
    private boolean _connected;
    private CountDownLatch _disconnected;
    private final Map<UUID, PointValue> _pointValues = new ConcurrentHashMap<UUID, PointValue>();
    private DNP3TestsSupport _support;

    public boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
        Require.success((this._disconnected.getCount() > 0L ? 1 : 0) != 0);
        this._disconnected.countDown();
        return true;
    }

    public boolean onNewConnection(PAPProxy remoteProxy) {
        Require.failure((boolean)this._connected);
        this._connected = true;
        return true;
    }

    public PointValue[] select(Point[] points) throws InterruptedException, ServiceNotAvailableException {
        PointValue[] pointValues = new PointValue[points.length];
        for (int i = 0; i < pointValues.length; ++i) {
            pointValues[i] = this._pointValues.get(points[i].getUUID().get());
        }
        return pointValues;
    }

    @BeforeClass
    public void setUp() {
        DNP3TestsSupport.setPortProperties();
        DNP3MasterOutstationTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this._support = new DNP3TestsSupport(Optional.of(this.getMetadata(true)));
    }

    @Test(priority=20)
    public void test() throws Exception {
        this._disconnected = new CountDownLatch(1);
        this._connected = false;
        DNP3Outstation outstation = this._support.getOutstation();
        outstation.setNeedTime();
        outstation.setResponder((PAPProxy.Responder)this);
        outstation.start();
        DNP3Master master = this._support.getMaster();
        Require.success((boolean)master.addConnectionListener((PAPConnectionListener)this));
        master.open();
        Require.failure((boolean)this._connected);
        this.expectLogs(new Messages.Entry[]{DNP3Messages.MASTER_CONNECTION_ACCEPTED});
        Require.success((boolean)master.connect(this._support.getOutstationOrigin(), (short)4));
        Require.success((boolean)this._connected);
        this.waitForLogs(new Messages.Entry[]{DNP3Messages.MASTER_CONNECTION_ACCEPTED});
        new _Tests(this._support, this).test();
        Require.success((this._disconnected.getCount() > 0L ? 1 : 0) != 0);
        this._support.clearMaster();
        Require.success((boolean)this._disconnected.await(this.getTimeout(), TimeUnit.MILLISECONDS));
        this._support.clearOutstation();
    }

    void _putValue(@Nonnull PointValue pointValue) {
        this._pointValues.put(pointValue.getPointUUID(), pointValue);
    }

    private static final class _Tests
    extends DNP3Tests {
        protected _Tests(@Nonnull DNP3TestsSupport suppport, @Nonnull DNP3MasterOutstationTests owner) {
            super(suppport, (Tests)owner);
        }

        @Override
        protected Optional<PointValue> getNextPointValue() {
            DNP3Outstation outstation = this.getSupport().getOutstation();
            try {
                return outstation.nextUpdate((long)this.getTimeout());
            }
            catch (InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        protected void putPointValue(PointValue pointValue) {
            ((DNP3MasterOutstationTests)this.getOwner())._putValue(pointValue);
        }
    }
}

