/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.util.Optional;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.tests.Tests;
import org.testng.annotations.Test;

public final class DNP3ObjectsValidation
extends Tests {
    @Test
    public static void validateGroups() {
        for (GroupCategory objectCategory : GroupCategory.values()) {
            for (ObjectGroup objectGroup : objectCategory.getObjectGroups()) {
                Require.success((objectGroup.getCode() >= objectCategory.getFromGroupCode() ? 1 : 0) != 0);
                Require.success((objectGroup.getCode() <= objectCategory.getToGroupCode() ? 1 : 0) != 0);
                Require.same((Object)objectGroup.getCategory(), (Object)objectCategory);
            }
        }
    }

    @Test
    public static void validateVariations() {
        for (GroupCategory objectCategory : GroupCategory.values()) {
            for (ObjectGroup objectGroup : objectCategory.getObjectGroups()) {
                for (ObjectVariation objectVariation : GroupCategory.objectVariations(Optional.ofNullable(objectGroup))) {
                    Require.same((Object)objectVariation.getObjectGroup(), (Object)objectGroup);
                    ObjectInstance objectInstance = GroupCategory.newObjectInstance((ObjectVariation)objectVariation);
                    String objectString = "Object '" + objectInstance + "'";
                    Require.same((Object)objectInstance.getObjectVariation(), (Object)objectVariation, (Object)objectString);
                    Require.equal((Object)objectInstance.getClass().getSimpleName(), (Object)("G" + objectInstance.getGroupCode() + "V" + objectInstance.getVariationCode()), (Object)objectString);
                }
            }
        }
    }
}

