/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.service.ServiceTests;

public abstract class DNP3Tests
extends ServiceTests {
    private static final String _TESTS_ANALOG_INPUT_SHORT_FLAGS_1 = "TESTS-DNP3.AI-SHORT-FLAGS.1";
    private static final String _TESTS_ANALOG_OUTPUT_SHORT_1 = "TESTS-DNP3.AO-SHORT.1";
    private static final String _TESTS_BINARY_INPUT_FLAGS_1 = "TESTS-DNP3.BI-FLAGS.1";
    private static final String _TESTS_BINARY_OUTPUT_FLAGS_1 = "TESTS-DNP3.BO-FLAGS.1";
    private static final String _TESTS_COUNTER_FLAGS_1 = "TESTS-DNP3.COUNTER-FLAGS.1";
    private final Tests _owner;
    private final DNP3TestsSupport _support;

    protected DNP3Tests(@Nonnull DNP3TestsSupport suppport, @Nonnull Tests owner) {
        this._owner = owner;
        this._support = suppport;
    }

    public void expectLogs(Messages.Entry ... entries) {
        this._owner.expectLogs(entries);
    }

    public void requireLogs(Messages.Entry ... entries) {
        this._owner.requireLogs(entries);
    }

    public final void test() throws Exception {
        this._testWriteRequests();
        if (!this.isWriteOnly()) {
            this._testReadRequests();
        }
    }

    public void waitForLogs(Messages.Entry ... entries) throws InterruptedException {
        this._owner.waitForLogs(entries);
    }

    @Nonnull
    @CheckReturnValue
    protected abstract Optional<PointValue> getNextPointValue();

    @Nonnull
    @CheckReturnValue
    protected final Origin getOrigin() {
        return this.getSupport().getOutstationOrigin();
    }

    @Nonnull
    @CheckReturnValue
    protected Tests getOwner() {
        return this._owner;
    }

    @Nonnull
    @CheckReturnValue
    protected final DNP3TestsSupport getSupport() {
        return this._support;
    }

    @CheckReturnValue
    protected boolean isWriteOnly() {
        return false;
    }

    protected abstract void putPointValue(@Nonnull PointValue var1) throws Exception;

    private final PointValue _expectUpdate(PointValue sentPointValue) throws Exception {
        Serializable receivedValue;
        Point point = (Point)sentPointValue.getPoint().get();
        Serializable value = sentPointValue.getValue();
        PointValue receivedPointValue = this.getNextPointValue().get();
        Require.equal((Object)receivedPointValue.getPointUUID(), point.getUUID().get());
        Serializable expectedValue = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : value;
        Serializable serializable = receivedValue = receivedPointValue.getValue() instanceof Number ? Long.valueOf(((Number)receivedPointValue.getValue()).longValue()) : receivedPointValue.getValue();
        if (expectedValue instanceof Tuple) {
            Tuple expectedTuple = (Tuple)expectedValue;
            Tuple receivedTuple = (Tuple)receivedValue;
            Require.equal((long)expectedTuple.size(), (long)receivedTuple.size());
            for (int i = 0; i < expectedTuple.size(); ++i) {
                Serializable expectedItem = expectedTuple.get(i);
                Serializable receivedItem = receivedTuple.get(i);
                if (expectedItem instanceof Number) {
                    expectedItem = Long.valueOf(((Number)expectedItem).longValue());
                }
                if (receivedItem instanceof Number) {
                    receivedItem = Long.valueOf(((Number)receivedItem).longValue());
                }
                Require.equal((Object)receivedItem, (Object)expectedItem);
            }
        } else {
            Require.equal((Object)receivedValue, (Object)expectedValue);
        }
        return receivedPointValue;
    }

    private void _receive(PointValue pointValue) throws Exception {
        this.putPointValue(pointValue);
        PointValue receivedPointValue = this._support.getMaster().read((Point)pointValue.getPoint().get());
        Require.equal((Object)receivedPointValue.getPointUUID(), (Object)pointValue.getPointUUID());
        Require.equal((Object)receivedPointValue.getValue(), (Object)pointValue.getValue());
    }

    private void _send(PointValue pointValue) throws Exception {
        this._support.getMaster().write(pointValue);
        this._expectUpdate(pointValue);
    }

    private void _testReadRequests() throws Exception {
        this._receive(new PointValue(this._support.getPoint(_TESTS_ANALOG_INPUT_SHORT_FLAGS_1), Optional.of(DateTime.now()), null, (Serializable)Short.valueOf((short)1234)));
        this._receive(new PointValue(this._support.getPoint(_TESTS_BINARY_INPUT_FLAGS_1), Optional.of(DateTime.now()), null, (Serializable)Boolean.TRUE));
        this._receive(new PointValue(this._support.getPoint(_TESTS_COUNTER_FLAGS_1), Optional.of(DateTime.now()), null, (Serializable)Integer.valueOf(12345)));
    }

    private void _testWriteRequests() throws Exception {
        this._send(new PointValue(this._support.getPoint(_TESTS_ANALOG_OUTPUT_SHORT_1), Optional.of(DateTime.now()), null, (Serializable)Short.valueOf((short)1234)));
        this._send(new PointValue(this._support.getPoint(_TESTS_BINARY_OUTPUT_FLAGS_1), Optional.of(DateTime.now()), null, (Serializable)Boolean.TRUE));
    }
}

