/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.dnp3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3Master;
import org.rvpf.pap.dnp3.DNP3MasterContext;
import org.rvpf.pap.dnp3.DNP3MasterProxy;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.pap.dnp3.DNP3OutstationContext;
import org.rvpf.pap.dnp3.DNP3OutstationProxy;
import org.rvpf.pap.dnp3.DNP3Proxy;
import org.rvpf.pap.dnp3.DNP3StationPoint;
import org.rvpf.pap.dnp3.DNP3Support;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.Connection;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.DataLinkLayer;
import org.rvpf.pap.dnp3.transport.Frame;
import org.rvpf.pap.dnp3.transport.LocalEndPoint;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.pap.dnp3.transport.SerialConnection;
import org.rvpf.pap.dnp3.transport.TCPConnection;
import org.rvpf.pap.dnp3.transport.UDPConnection;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.PAPTestsSupport;
import org.rvpf.tests.service.ServiceTests;

public final class DNP3TestsSupport
extends PAPTestsSupport {
    public static final short TESTS_MASTER_DEVICE_ADDRESS = 3;
    public static final String TESTS_MASTER_LISTEN_PROPERTIES = "tests.master.listen";
    public static final String TESTS_MASTER_TCP_PORT_PROPERTY = "tests.dnp3.master.tcp.port";
    public static final String TESTS_MASTER_UDP_PORT_PROPERTY = "tests.dnp3.master.udp.port";
    public static final short TESTS_OUTSTATION_DEVICE_ADDRESS = 4;
    public static final String TESTS_OUTSTATION_LISTEN_PROPERTIES = "tests.outstation.listen";
    public static final String TESTS_OUTSTATION_TCP_PORT_PROPERTY = "tests.dnp3.outstation.tcp.port";
    public static final String TESTS_OUTSTATION_UDP_PORT_PROPERTY = "tests.dnp3.outstation.udp.port";
    private static final String _DNP3_ORIGIN_NAME = "TestsDNP3";
    private static int _masterTCPPort;
    private static int _masterUDPPort;
    private static int _outstationTCPPort;
    private static int _outstationUDPPort;
    private final AtomicReference<DNP3Master> _master = new AtomicReference();
    private final AtomicReference<DNP3Outstation> _outstation = new AtomicReference();
    private volatile boolean _outstationLocal;

    public DNP3TestsSupport(@Nonnull Optional<Metadata> metadata) {
        super(metadata);
    }

    @CheckReturnValue
    public static int getMasterTCPPort() {
        return _masterTCPPort;
    }

    @CheckReturnValue
    public static int getMasterUDPPort() {
        return _masterUDPPort;
    }

    @CheckReturnValue
    public static int getOutstationTCPPort() {
        return _outstationTCPPort;
    }

    @CheckReturnValue
    public static int getOutstationUDPPort() {
        return _outstationUDPPort;
    }

    public static void setPortProperties() {
        _masterTCPPort = Tests.allocateTCPPort();
        ServiceTests.setProperty((String)TESTS_MASTER_TCP_PORT_PROPERTY, (String)String.valueOf(_masterTCPPort));
        _masterUDPPort = Tests.allocateUDPPort();
        ServiceTests.setProperty((String)TESTS_MASTER_UDP_PORT_PROPERTY, (String)String.valueOf(_masterUDPPort));
        _outstationTCPPort = Tests.allocateTCPPort();
        ServiceTests.setProperty((String)TESTS_OUTSTATION_TCP_PORT_PROPERTY, (String)String.valueOf(_outstationTCPPort));
        _outstationUDPPort = Tests.allocateUDPPort();
        ServiceTests.setProperty((String)TESTS_OUTSTATION_UDP_PORT_PROPERTY, (String)String.valueOf(_outstationUDPPort));
    }

    public void clearMaster() {
        DNP3Master master = this._master.getAndSet(null);
        if (master != null) {
            master.tearDown();
        }
    }

    public void clearOutstation() {
        DNP3Outstation outstation = this._outstation.getAndSet(null);
        if (outstation != null) {
            outstation.tearDown();
        }
    }

    @Nonnull
    @CheckReturnValue
    public DNP3Master getMaster() {
        DNP3Master master = this._master.get();
        if (master == null) {
            DNP3Support support = new DNP3Support();
            Metadata metadata = this.getMetadata().get();
            DNP3MasterContext masterContext = support.newClientContext(metadata, Optional.empty());
            Require.notNull((Object)masterContext);
            master = support.newMaster(masterContext, (short)3);
            Require.success((boolean)master.setUp((KeyedValues)metadata.getPropertiesGroup(TESTS_MASTER_LISTEN_PROPERTIES)));
            if (!this._master.compareAndSet(null, master)) {
                master = this._master.get();
            }
        }
        return master;
    }

    @Nonnull
    @CheckReturnValue
    public DNP3Outstation getOutstation() {
        DNP3Outstation outstation = this._outstation.get();
        if (outstation == null) {
            Metadata metadata = this.getMetadata().get();
            DNP3Support support = new DNP3Support();
            DNP3OutstationContext context = support.newServerContext(metadata, new String[0], Optional.empty());
            KeyedGroups serverProperties = new KeyedGroups();
            outstation = support.newServer((PAPContext)context);
            serverProperties.addGroup("listener", metadata.getPropertiesGroup(TESTS_OUTSTATION_LISTEN_PROPERTIES));
            Require.success((boolean)outstation.setUp(serverProperties));
            if (!this._outstation.compareAndSet(null, outstation)) {
                outstation = this._outstation.get();
            }
        }
        this._outstationLocal = true;
        return outstation;
    }

    @Nonnull
    @CheckReturnValue
    public Origin getOutstationOrigin() {
        Optional outstationOrigin = this.getMetadata().get().getOriginEntity(Optional.of(_DNP3_ORIGIN_NAME));
        return (Origin)outstationOrigin.get();
    }

    @Nonnull
    @CheckReturnValue
    public Point getPoint(@Nonnull String key) {
        return (Point)this.getMetadata().get().getPoint(key).get();
    }

    @Nonnull
    @CheckReturnValue
    public DNP3Proxy getPointProxy(Point point) {
        Optional proxy = this.getMaster().getPointProxy(point);
        return (DNP3Proxy)proxy.get();
    }

    @Nonnull
    @CheckReturnValue
    public RemoteEndPoint getRemoteEndPoint(@Nonnull DNP3Proxy proxy) {
        Optional remoteEndPoint = this.getMaster().getRemoteEndPoint(proxy);
        return (RemoteEndPoint)remoteEndPoint.get();
    }

    @Nonnull
    @CheckReturnValue
    public DNP3StationPoint getStationPoint(Point point) {
        return this.getMaster().getStationPoint(point);
    }

    @CheckReturnValue
    public boolean isOutstationLocal() {
        return this._outstationLocal;
    }

    @Nonnull
    @CheckReturnValue
    public Connection newSerialConnection(boolean fromMaster, @Nonnull String portName, int portSpeed) throws IOException {
        Optional traces = Optional.empty();
        DNP3MasterContext context = fromMaster ? new DNP3MasterContext(this.getMetadata(), traces) : new DNP3OutstationContext(this.getMetadata(), new String[0], traces);
        ConnectionManager connectionManager = new ConnectionManager((DNP3Context)context);
        LocalEndPoint localEndPoint = new LocalEndPoint(connectionManager);
        DNP3OutstationProxy proxy = fromMaster ? new DNP3OutstationProxy((DNP3Context)context, "") : new DNP3MasterProxy((DNP3Context)context, "");
        _RemoteEndPoint remoteEndPoint = new _RemoteEndPoint(connectionManager, (DNP3Proxy)proxy);
        SerialConnection connection = new SerialConnection(localEndPoint, (RemoteEndPoint)remoteEndPoint, portName, portSpeed);
        Require.success((boolean)proxy.setUp(new Attributes("DNP3")));
        remoteEndPoint.setConnection((Connection)connection);
        connection.purge();
        return connection;
    }

    @Nonnull
    @CheckReturnValue
    public Connection newTCPConnection(boolean fromMaster, @Nonnull SocketChannel socketChannel) {
        Optional traces = Optional.empty();
        DNP3MasterContext context = fromMaster ? new DNP3MasterContext(this.getMetadata(), traces) : new DNP3OutstationContext(this.getMetadata(), new String[0], traces);
        ConnectionManager connectionManager = new ConnectionManager((DNP3Context)context);
        LocalEndPoint localEndPoint = new LocalEndPoint(connectionManager);
        DNP3OutstationProxy proxy = fromMaster ? new DNP3OutstationProxy((DNP3Context)context, "") : new DNP3MasterProxy((DNP3Context)context, "");
        _RemoteEndPoint remoteEndPoint = new _RemoteEndPoint(connectionManager, (DNP3Proxy)proxy);
        TCPConnection connection = new TCPConnection(localEndPoint, (RemoteEndPoint)remoteEndPoint, socketChannel);
        Require.success((boolean)proxy.setUp(new Attributes("DNP3")));
        remoteEndPoint.setConnection((Connection)connection);
        return connection;
    }

    @Nonnull
    @CheckReturnValue
    public Connection newUDPConnection(boolean fromMaster, @Nonnull InetSocketAddress localAddress, @Nonnull InetSocketAddress remoteAddress) throws IOException {
        DatagramChannel datagramChannel = DatagramChannel.open(StandardProtocolFamily.INET);
        datagramChannel.bind(localAddress);
        Optional traces = Optional.empty();
        DNP3MasterContext context = fromMaster ? new DNP3MasterContext(this.getMetadata(), traces) : new DNP3OutstationContext(this.getMetadata(), new String[0], traces);
        ConnectionManager connectionManager = new ConnectionManager((DNP3Context)context);
        LocalEndPoint localEndPoint = new LocalEndPoint(connectionManager);
        DNP3OutstationProxy proxy = fromMaster ? new DNP3OutstationProxy((DNP3Context)context, "") : new DNP3MasterProxy((DNP3Context)context, "");
        _RemoteEndPoint remoteEndPoint = new _RemoteEndPoint(connectionManager, (DNP3Proxy)proxy);
        _UDPTestsConnection connection = new _UDPTestsConnection(localEndPoint, remoteEndPoint, datagramChannel, remoteAddress);
        Require.success((boolean)proxy.setUp(new Attributes("DNP3")));
        remoteEndPoint.setConnection(connection);
        return connection;
    }

    private static final class _UDPTestsConnection
    extends Connection {
        final UDPConnection _udpConnection;
        private final DatagramChannel _datagramChannel;
        private final ByteBuffer _receiveBuffer = ByteBuffer.allocate(512);
        private final InetSocketAddress _remoteAddress;

        _UDPTestsConnection(@Nonnull LocalEndPoint localEndPoint, @Nonnull RemoteEndPoint remoteEndPoint, @Nonnull DatagramChannel datagramChannel, @Nonnull InetSocketAddress remoteAddress) {
            super(localEndPoint, remoteEndPoint);
            this._datagramChannel = datagramChannel;
            this._remoteAddress = remoteAddress;
            this._udpConnection = new UDPConnection(localEndPoint, remoteEndPoint, datagramChannel, remoteAddress);
        }

        public void doClose() throws IOException {
            this._udpConnection.close();
            this._datagramChannel.close();
            super.doClose();
        }

        protected void doReceive(ByteBuffer buffer) throws IOException {
            Require.equal((Object)this._datagramChannel.receive(this._receiveBuffer), (Object)this._remoteAddress);
            this._receiveBuffer.flip();
            this._udpConnection.onDatagramReceived(this._receiveBuffer);
            this._receiveBuffer.clear();
            this._udpConnection.receive(buffer);
        }

        protected void doSend(ByteBuffer buffer) throws IOException {
            this._udpConnection.send(buffer);
        }

        protected String getName() {
            return "UDP-Test";
        }
    }

    private static final class _RemoteEndPoint
    extends RemoteEndPoint {
        private Connection _connection;

        public _RemoteEndPoint(@Nonnull ConnectionManager connectionManager, @Nonnull DNP3Proxy remoteProxy) {
            super(connectionManager, remoteProxy);
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void onFrameReceived(@Nonnull Frame frame) throws IOException {
            Association association = this.getAssociation((short)0, (short)0);
            DataLinkLayer dataLinkLayer = association.getDataLinkLayer();
            dataLinkLayer.accept(frame);
        }

        void setConnection(@Nonnull Connection connection) {
            this._connection = connection;
        }
    }
}

