/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.pap.modbus;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ConnectFailedException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.pap.modbus.ModbusClient;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.register.Register;
import org.rvpf.tests.Tests;
import org.rvpf.tests.pap.modbus.ModbusTestsSupport;
import org.rvpf.tests.service.ServiceTests;

public abstract class ModbusTests
extends ServiceTests {
    private static final String _TESTS_COIL_1 = "TESTS-MODBUS.COIL.1";
    private static final String _TESTS_COIL_2 = "TESTS-MODBUS.COIL.2";
    private static final String _TESTS_COIL_3 = "TESTS-MODBUS.COIL.3";
    private static final String _TESTS_COIL_ARRAY_1 = "TESTS-MODBUS.COIL-ARRAY.1";
    private static final String _TESTS_DISCRETE_1 = "TESTS-MODBUS.DISCRETE.1";
    private static final String _TESTS_DISCRETE_2 = "TESTS-MODBUS.DISCRETE.2";
    private static final String _TESTS_DISCRETE_3 = "TESTS-MODBUS.DISCRETE.3";
    private static final String _TESTS_INPUT_1 = "TESTS-MODBUS.INPUT.1";
    private static final String _TESTS_INPUT_2 = "TESTS-MODBUS.INPUT.2";
    private static final String _TESTS_MASKED_REGISTER_1 = "TESTS-MODBUS.MASKED-REGISTER.1";
    private static final String _TESTS_REGISTER_1 = "TESTS-MODBUS.REGISTER.1";
    private static final String _TESTS_REGISTER_2 = "TESTS-MODBUS.REGISTER.2";
    private static final String _TESTS_REGISTER_3 = "TESTS-MODBUS.REGISTER.3";
    private static final String _TESTS_REGISTER_4 = "TESTS-MODBUS.REGISTER.4";
    private static final String _TESTS_REGISTER_ARRAY_1 = "TESTS-MODBUS.REGISTER-ARRAY.1";
    private static final int _TESTS_UNCONFIGURED_REGISTER_ADDRESS = 99;
    private final Tests _owner;
    private PointValue _peekedPointValue;
    private DateTime _stamp;
    private final ModbusTestsSupport _support;

    protected ModbusTests(@Nonnull ModbusTestsSupport suppport, @Nonnull Tests owner) {
        this._owner = owner;
        this._support = suppport;
    }

    public void expectLogs(Messages.Entry ... entries) {
        this._owner.expectLogs(entries);
    }

    public void requireLogs(Messages.Entry ... entries) {
        this._owner.requireLogs(entries);
    }

    public final void test() throws Exception {
        this._testWriteRequests();
        if (!this.isWriteOnly()) {
            this._testReadRequests();
        }
    }

    public void waitForLogs(Messages.Entry ... entries) throws InterruptedException {
        this._owner.waitForLogs(entries);
    }

    @Nonnull
    @CheckReturnValue
    protected abstract Optional<PointValue> getNextPointValue();

    @Nonnull
    @CheckReturnValue
    protected Tests getOwner() {
        return this._owner;
    }

    @Nonnull
    @CheckReturnValue
    protected final ModbusTestsSupport getSupport() {
        return this._support;
    }

    @CheckReturnValue
    protected boolean isWriteOnly() {
        return false;
    }

    protected void putValue(@Nonnull Point point, @Nonnull DateTime stamp, @Nonnull Serializable value) throws Exception {
    }

    private static short[] _sendReadRequest(Optional<Transaction.Request> request) throws Exception {
        ReadTransaction.Response response = (ReadTransaction.Response)ModbusTests._sendRequest(request);
        return response.getValues();
    }

    private static Transaction.Response _sendRequest(Optional<Transaction.Request> request) throws Exception {
        Transaction.Response response = (Transaction.Response)request.get().getResponse().get();
        Require.success((boolean)response.isSuccess());
        return response;
    }

    private final PointValue _expectUpdate(Point point, Serializable value) throws Exception {
        Serializable receivedValue;
        PointValue pointValue = this._nextPointValue();
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Serializable expectedValue = value instanceof Number ? Long.valueOf(((Number)value).longValue()) : value;
        Serializable serializable = receivedValue = pointValue.getValue() instanceof Number ? Long.valueOf(((Number)pointValue.getValue()).longValue()) : pointValue.getValue();
        if (expectedValue instanceof Tuple) {
            Tuple expectedTuple = (Tuple)expectedValue;
            Tuple receivedTuple = (Tuple)receivedValue;
            Require.equal((long)expectedTuple.size(), (long)receivedTuple.size());
            for (int i = 0; i < expectedTuple.size(); ++i) {
                Serializable expectedItem = expectedTuple.get(i);
                Serializable receivedItem = receivedTuple.get(i);
                if (expectedItem instanceof Number) {
                    expectedItem = Long.valueOf(((Number)expectedItem).longValue());
                }
                if (receivedItem instanceof Number) {
                    receivedItem = Long.valueOf(((Number)receivedItem).longValue());
                }
                Require.equal((Object)receivedItem, (Object)expectedItem);
            }
        } else {
            Require.equal((Object)receivedValue, (Object)expectedValue);
        }
        if (this._support.isServerLocal()) {
            this.putValue(point, this._stamp, value);
        }
        return pointValue;
    }

    private final Origin _getOrigin() {
        return this.getSupport().getServerOrigin();
    }

    private PointValue _nextPointValue() {
        PointValue pointValue = this._peekedPointValue;
        if (pointValue != null) {
            this._peekedPointValue = null;
            return pointValue;
        }
        return this.getNextPointValue().get();
    }

    private PointValue _peekPointValue() {
        if (this._peekedPointValue == null) {
            this._peekedPointValue = this.getNextPointValue().get();
        }
        return this._peekedPointValue;
    }

    private PointValue _sendReadPointValueRequest(Point point) throws InterruptedException, ConnectFailedException {
        ModbusClient client = this._support.getClient();
        ReadTransaction.Request request = (ReadTransaction.Request)client.requestPointValue(point).get();
        Transaction.Response response = (Transaction.Response)request.getResponse().get();
        return (PointValue)((ReadTransaction.Response)response).getPointValue().get();
    }

    private void _testReadRequests() throws Exception {
        ModbusClient client = this._support.getClient();
        Map<Point, Register> registersByPoint = this._support.getRegistersByPoint();
        Point register1 = this._support.getPoint(_TESTS_REGISTER_1);
        Register register1Register = registersByPoint.get(register1);
        Integer register1Address = (Integer)register1Register.getAddress().get();
        Point maskRegister1 = this._support.getPoint(_TESTS_MASKED_REGISTER_1);
        ModbusTests._sendRequest(client.writeSingleRegister(this._getOrigin(), register1Address.intValue(), 65535));
        this._expectUpdate(register1, Long.valueOf(65535L));
        ModbusTests._sendRequest(client.writePointValue(new PointValue(maskRegister1, Optional.of(this._stamp), null, (Serializable)Integer.valueOf(272))));
        this._expectUpdate(register1, Long.valueOf(61727L));
        Require.equal((Object)this._sendReadPointValueRequest(maskRegister1).getValue(), (Object)272);
        Point coil1Point = this._support.getPoint(_TESTS_COIL_1);
        Map<Point, Register> coilsByPoint = this._support.getCoilsByPoint();
        Register coil1Register = coilsByPoint.get(coil1Point);
        Integer coil1Address = (Integer)coil1Register.getAddress().get();
        int coil0Address = coil1Address - 1;
        Require.success((boolean)Arrays.equals(ModbusTests._sendReadRequest(client.readCoils(this._getOrigin(), coil0Address, 4)), new short[]{1, 0, 1, 0}));
        Require.equal((Object)this._sendReadPointValueRequest(coil1Point).getValue(), (Object)Boolean.FALSE);
        Point coilArray1 = this._support.getPoint(_TESTS_COIL_ARRAY_1);
        Tuple tuple = new Tuple();
        tuple.add((Serializable)Boolean.FALSE);
        tuple.add((Serializable)Boolean.TRUE);
        tuple.add((Serializable)Boolean.FALSE);
        this.putValue(coilArray1, this._stamp, (Serializable)tuple.clone());
        Require.equal((Object)this._sendReadPointValueRequest(coilArray1).getValue(), (Object)tuple);
        int stampAddress = register1Address - 5;
        Require.success((boolean)Arrays.equals(ModbusTests._sendReadRequest(client.readHoldingRegisters(this._getOrigin(), stampAddress, 9)), new short[]{ModbusClient.stamp0((DateTime)this._stamp), ModbusClient.stamp1((DateTime)this._stamp), 1, 5, 2, -3809, 5, 4, 6}));
        Require.equal((Object)this._sendReadPointValueRequest(register1).getValue(), (Object)61727);
        Point registerArray1 = this._support.getPoint(_TESTS_REGISTER_ARRAY_1);
        tuple.clear();
        tuple.add((Serializable)Short.valueOf((short)4));
        tuple.add((Serializable)Short.valueOf((short)5));
        tuple.add((Serializable)Short.valueOf((short)6));
        this.putValue(registerArray1, this._stamp, (Serializable)tuple.clone());
        Require.equal((Object)this._sendReadPointValueRequest(registerArray1).getValue(), (Object)tuple);
        Point discrete1 = this._support.getPoint(_TESTS_DISCRETE_1);
        Point discrete2 = this._support.getPoint(_TESTS_DISCRETE_2);
        Point discrete3 = this._support.getPoint(_TESTS_DISCRETE_3);
        Map<Point, Register> discretesByPoint = this._support.getDiscretesByPoint();
        Register discrete0Register = discretesByPoint.get(coil1Point);
        Integer discrete0Address = (Integer)discrete0Register.getAddress().get();
        this.putValue(discrete1, this._stamp, Boolean.TRUE);
        this.putValue(discrete2, this._stamp, Boolean.TRUE);
        this.putValue(discrete3, this._stamp, Boolean.TRUE);
        Require.success((boolean)Arrays.equals(ModbusTests._sendReadRequest(client.readDiscreteInputs(this._getOrigin(), discrete0Address.intValue(), 5)), new short[]{0, 0, 1, 1, 0}));
        Point input1 = this._support.getPoint(_TESTS_INPUT_1);
        Point input2 = this._support.getPoint(_TESTS_INPUT_2);
        Map<Point, Register> inputsByPoint = this._support.getInputsByPoint();
        Register input0Register = inputsByPoint.get(discrete1);
        Integer input0Address = (Integer)input0Register.getAddress().get();
        this.putValue(input1, this._stamp, Integer.valueOf(11));
        this.putValue(input2, this._stamp, Integer.valueOf(12));
        Require.success((boolean)Arrays.equals(ModbusTests._sendReadRequest(client.readInputRegisters(this._getOrigin(), input0Address.intValue(), 3)), new short[]{4, 11, 12}));
        DateTime then = DateTime.now();
        short[] timeWords = ModbusTests._sendReadRequest(client.readInputRegisters(this._getOrigin(), input0Address + 3, 4));
        DateTime time = ModbusClient.dateTime((short[])timeWords);
        Require.success((boolean)then.isNotAfter(time));
        Require.success((boolean)time.isNotAfter(DateTime.now()));
    }

    private void _testWriteRequests() throws Exception {
        ModbusClient client = this._support.getClient();
        Point coil1 = this._support.getPoint(_TESTS_COIL_1);
        Point coil2 = this._support.getPoint(_TESTS_COIL_2);
        Point coil3 = this._support.getPoint(_TESTS_COIL_3);
        Map<Point, Register> coilsByPoint = this._support.getCoilsByPoint();
        Register coil1Register = coilsByPoint.get(coil1);
        Integer coil1Address = (Integer)coil1Register.getAddress().get();
        int coil0Address = coil1Address - 1;
        this._stamp = DateTime.now();
        ModbusTests._sendRequest(client.writeSingleCoil(this._getOrigin(), coil0Address + 1, 1));
        this._expectUpdate(coil1, Boolean.TRUE);
        ModbusTests._sendRequest(client.writeMultipleCoils(this._getOrigin(), coil0Address, new short[]{1, 0, 1, 1}));
        this._expectUpdate(coil1, Boolean.FALSE);
        this._expectUpdate(coil2, Boolean.TRUE);
        this._expectUpdate(coil3, Boolean.TRUE);
        Map<Point, Register> registersByPoint = this._support.getRegistersByPoint();
        Register bitsRegister = registersByPoint.get(coil1);
        Integer bitsAddress = (Integer)bitsRegister.getAddress().get();
        if (!this.isWriteOnly()) {
            ModbusTests._sendRequest(client.maskWriteRegister(this._getOrigin(), bitsAddress.intValue(), 5, 2));
            this._expectUpdate(coil1, Boolean.TRUE);
            this._expectUpdate(coil2, Boolean.TRUE);
            this._expectUpdate(coil3, Boolean.FALSE);
        }
        ModbusTests._sendRequest(client.writeSingleRegister(this._getOrigin(), bitsAddress.intValue(), 0));
        this._expectUpdate(coil1, Boolean.FALSE);
        this._expectUpdate(coil2, Boolean.FALSE);
        this._expectUpdate(coil3, Boolean.FALSE);
        ModbusTests._sendRequest(client.writeSingleRegister(this._getOrigin(), bitsAddress.intValue(), -1));
        this._expectUpdate(coil1, Boolean.TRUE);
        this._expectUpdate(coil2, Boolean.TRUE);
        this._expectUpdate(coil3, Boolean.TRUE);
        Point coilArray1 = this._support.getPoint(_TESTS_COIL_ARRAY_1);
        Tuple tuple = new Tuple();
        tuple.add((Serializable)Boolean.TRUE);
        tuple.add((Serializable)Boolean.FALSE);
        tuple.add((Serializable)Boolean.TRUE);
        ModbusTests._sendRequest(client.writePointValue(new PointValue(coilArray1, Optional.of(DateTime.now()), null, (Serializable)tuple)));
        this._expectUpdate(coilArray1, (Serializable)tuple);
        Point register1 = this._support.getPoint(_TESTS_REGISTER_1);
        Point register2 = this._support.getPoint(_TESTS_REGISTER_2);
        Point register3 = this._support.getPoint(_TESTS_REGISTER_3);
        Point register4 = this._support.getPoint(_TESTS_REGISTER_4);
        Register register1Register = registersByPoint.get(register1);
        Integer register1Address = (Integer)register1Register.getAddress().get();
        int stampAddress = register1Address - 5;
        this._stamp = DateTime.now().floored(ElapsedTime.MILLI.toRaw() / 10L).after(1L * ElapsedTime.SECOND.toRaw());
        ModbusTests._sendRequest(client.writeMultipleRegisters(this._getOrigin(), stampAddress, new short[]{ModbusClient.stamp0((DateTime)this._stamp), ModbusClient.stamp1((DateTime)this._stamp), 1, 5, 2, 3, 5, 4, 6, 8192, 18417}));
        Require.notNull((Object)this._peekPointValue());
        if (this._support.isServerLocal()) {
            Require.equal((Object)this._stamp, (Object)this._support.getRemoteProxy().getStamp());
            Require.equal((long)1L, (long)this._support.getRemoteProxy().getSequence());
        }
        Require.equal((Object)this._expectUpdate(coil1, Boolean.FALSE).getStamp(), (Object)this._stamp);
        Require.equal((Object)this._expectUpdate(coil2, Boolean.TRUE).getStamp(), (Object)this._stamp);
        Require.equal((Object)this._expectUpdate(coil3, Boolean.FALSE).getStamp(), (Object)this._stamp);
        Require.equal((Object)this._expectUpdate(register1, Short.valueOf((short)3)).getStamp(), (Object)this._stamp);
        Require.equal((Object)this._expectUpdate(register2, Integer.valueOf(262149)).getStamp(), (Object)this._stamp);
        Require.equal((Object)this._expectUpdate(register3, Short.valueOf((short)6)).getStamp(), (Object)this._stamp);
        Require.equal((Object)this._expectUpdate(register4, Float.valueOf(123456.0f)).getStamp(), (Object)this._stamp);
        ModbusTests._sendRequest(client.writePointValue(new PointValue(register4, Optional.of(this._stamp), null, (Serializable)Float.valueOf(654321.0f))));
        Require.equal((Object)this._expectUpdate(register4, Float.valueOf(654321.0f)).getStamp(), (Object)this._stamp);
        Register register3Register = registersByPoint.get(register3);
        Integer register3Address = (Integer)register3Register.getAddress().get();
        if (!this.isWriteOnly()) {
            Require.success((boolean)Arrays.equals(ModbusTests._sendReadRequest(client.writeReadMultipleRegisters(this._getOrigin(), register3Address.intValue(), new short[]{0, 0, 0}, register1Address.intValue(), 3)), new short[]{3, 5, 4}));
            this._expectUpdate(register3, Integer.valueOf(0));
            this._expectUpdate(register4, Float.valueOf(0.0f));
        }
        ModbusTests._sendRequest(client.writePointValue(new PointValue(register3, Optional.of(this._stamp), null, (Serializable)Long.valueOf(6L))));
        Require.equal((Object)this._expectUpdate(register3, Double.valueOf(6.0)).getStamp(), (Object)this._stamp);
        Point registerArray1 = this._support.getPoint(_TESTS_REGISTER_ARRAY_1);
        tuple.clear();
        tuple.add((Serializable)Short.valueOf((short)1));
        tuple.add((Serializable)Short.valueOf((short)2));
        tuple.add((Serializable)Short.valueOf((short)3));
        ModbusTests._sendRequest(client.writePointValue(new PointValue(registerArray1, Optional.of(this._stamp), null, (Serializable)tuple)));
        this._expectUpdate(registerArray1, (Serializable)tuple);
        this.expectLogs(new Messages.Entry[]{ModbusMessages.UNCONFIGURED_REGISTER});
        ModbusTests._sendRequest(client.writeSingleRegister(this._getOrigin(), 99, 0));
        this.waitForLogs(new Messages.Entry[]{ModbusMessages.UNCONFIGURED_REGISTER});
        ModbusTests._sendRequest(client.writeSingleRegister(this._getOrigin(), 99, 0));
    }
}

