/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.processor.engine.pap.cip;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.cip.CIPClient;
import org.rvpf.pap.cip.CIPSupport;
import org.rvpf.processor.ProcessorServiceActivator;
import org.rvpf.service.ServiceActivator;
import org.rvpf.tests.store.StoreClientTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SplitterEngineTests
extends StoreClientTests {
    private static final String _TESTS_PROPERTIES = "rvpf-cip.properties";
    private static final String _TESTS_SPLITTED_1 = "TESTS-CIP.SPLITTED.1";
    private static final String _TESTS_SPLIT_3 = "TESTS-CIP.SPLIT.3";
    private static final String _TESTS_SPLIT_4 = "TESTS-CIP.SPLIT.4";
    private ServiceActivator _processorService;
    private StoreSessionProxy _storeProxy;
    private ServiceActivator _storeService;

    @BeforeClass
    public void setUp() throws Exception {
        SplitterEngineTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this.setUpAlerter();
        Metadata metadata = this.getMetadata(true);
        this._storeService = this.startStoreService(true);
        this._storeProxy = this.getStoreProxy(this._storeService);
        this._processorService = this.createService(ProcessorServiceActivator.class, Optional.empty());
        SplitterEngineTests.startService((ServiceActivator)this._processorService);
        CIPSupport support = new CIPSupport();
        CIPClient client = support.newClient((PAPContext)support.newClientContext(metadata, Optional.empty()));
        Point arrayPoint = (Point)metadata.getPoint(_TESTS_SPLITTED_1).get();
        Attributes attributes = (Attributes)arrayPoint.getAttributes("CIP").get();
        int elements = attributes.getInt("ELEMENTS", 0);
        Tuple array = new Tuple();
        for (int i = 0; i < elements; ++i) {
            array.add((Serializable)Integer.valueOf(i));
        }
        Require.present((Optional)client.requestPointUpdate(new PointValue(arrayPoint, Optional.empty(), null, (Serializable)array)));
        Require.ignored((Object)client.commitPointUpdateRequests());
        client.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this._processorService != null) {
            this.stopService(this._processorService);
            this._processorService = null;
        }
        this._storeProxy.disconnect();
        if (this._storeService != null) {
            this.stopService(this._storeService);
            this._storeService = null;
        }
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        Point splitPoint3 = this.getPoint(_TESTS_SPLIT_3);
        Point splitPoint4 = this.getPoint(_TESTS_SPLIT_4);
        UUID[] subscribed = new UUID[]{(UUID)splitPoint3.getUUID().get(), (UUID)splitPoint4.getUUID().get()};
        Require.success((boolean)this._storeProxy.subscribeAndCheck(subscribed, this.getThisLogger()));
        Point splittedPoint = this.getPoint(_TESTS_SPLITTED_1);
        Attributes attributes = (Attributes)splittedPoint.getAttributes("CIP").get();
        int elements = attributes.getInt("ELEMENTS", 0);
        Tuple array = new Tuple(elements);
        for (int index = 0; index < elements; ++index) {
            array.add((Serializable)Integer.valueOf(index * 10));
        }
        PointValue splittedPointValue = new PointValue(splittedPoint, Optional.of(DateTime.now()), null, (Serializable)array);
        Require.success((boolean)this._storeProxy.updateAndCheck(splittedPointValue, this.getThisLogger()));
        StoreValues response = this._storeProxy.deliver(100, (long)this.getTimeout());
        Require.success((boolean)response.isSuccess());
        Require.equal((long)2L, (long)response.size());
        PointValue splitPointValue3 = response.getPointValue(0);
        Require.equal((Object)splitPointValue3.getStamp(), (Object)splittedPointValue.getStamp());
        Require.equal((Object)splitPointValue3.getValue(), (Object)30L);
        PointValue splitPointValue4 = response.getPointValue(1);
        Require.equal((Object)splitPointValue4.getStamp(), (Object)splittedPointValue.getStamp());
        Require.equal((Object)splitPointValue4.getValue(), (Object)40L);
        Require.success((boolean)this._storeProxy.unsubscribeAndCheck(subscribed, this.getThisLogger()));
    }
}

