/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.service.pap.datalogger.dnp3;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.pap.datalogger.DataloggerServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.service.MetadataServiceTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DataloggerServiceTests
extends MetadataServiceTests
implements PAPProxy.Responder {
    private static final String _DNP3_NAME = "DNP3";
    private static final String _SINK_QUEUE_NAME = "TestsSink";
    private static final String _TESTS_PROPERTIES = "rvpf-dnp3-datalogger.properties";
    private static final String _TESTS_REGISTER_1 = "TESTS-DNP3.REGISTER.1";
    private static final String _TESTS_SCANNED_1 = "TESTS-DNP3.SCANNED.1";
    private static final String _TESTS_SPLITTED_1 = "TESTS-DNP3.SPLITTED.1";
    private static final String _TESTS_SPLIT_1 = "TESTS-DNP3.SPLIT.1";
    private static final String _TESTS_SPLIT_2 = "TESTS-DNP3.SPLIT.2";
    private static final String _TESTS_STATE_1 = "TESTS-DNP3.STATE.1";
    private DNP3TestsSupport _dnp3Support;
    private final Map<Point, PointValue> _pointValues = new HashMap<Point, PointValue>();
    private MessagingSupport.Receiver _somReceiver;

    public PointValue[] select(Point[] points) throws InterruptedException, ServiceNotAvailableException {
        PointValue[] pointValues = new PointValue[points.length];
        for (int i = 0; i < pointValues.length; ++i) {
            pointValues[i] = this._pointValues.get(points[i]);
        }
        return pointValues;
    }

    @BeforeClass
    public void setUp() throws Exception {
        DataloggerServiceTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        DateTime.simulateTime((DateTime)DateTime.now().midnight());
        DataloggerServiceTests.setProperty((String)"tests.dnp3.outstation.tcp.port", (String)String.valueOf(DataloggerServiceTests.allocateTCPPort()));
        this.setUpAlerter();
        this._somReceiver = this.getMessaging().createServerReceiver(_SINK_QUEUE_NAME);
        Metadata metadata = this.getMetadata(true);
        this._dnp3Support = new DNP3TestsSupport(Optional.of(metadata));
        Point registerPoint = (Point)this.getMetadata().getPoint(_TESTS_REGISTER_1).get();
        this._pointValues.put(registerPoint, new PointValue(registerPoint, Optional.empty(), null, (Serializable)Integer.valueOf(12345)));
        Point splittedPoint = (Point)metadata.getPoint(_TESTS_SPLITTED_1).get();
        Attributes attributes = (Attributes)splittedPoint.getAttributes(_DNP3_NAME).get();
        int startIndex = attributes.getInt("START_INDEX", -1);
        int stopIndex = attributes.getInt("STOP_INDEX", -1);
        int elements = 1 + stopIndex - startIndex;
        Tuple tuple = new Tuple(elements);
        for (int index = 0; index < elements; ++index) {
            tuple.add((Serializable)Integer.valueOf(index));
        }
        this._pointValues.put(splittedPoint, new PointValue(splittedPoint, Optional.empty(), null, (Serializable)tuple));
        DNP3Outstation outstation = this._dnp3Support.getOutstation();
        outstation.setResponder((PAPProxy.Responder)this);
        outstation.start();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._dnp3Support.getOutstation().stop();
        this._somReceiver.close();
        this.tearDownAlerter();
        DateTime.clearSimulatedTime();
        DataloggerServiceTests.restoreSystemProperties();
    }

    @Test
    public void test() throws Exception {
        this.quell(new Messages.Entry[]{PAPMessages.NO_POINTS_TO_SCAN});
        ServiceActivator dataloggerService = this.startService(DataloggerServiceActivator.class, Optional.of(_DNP3_NAME));
        try {
            this._receive(_TESTS_STATE_1, null);
            this._receive(_TESTS_STATE_1, Boolean.TRUE);
            this._receive(_TESTS_SCANNED_1, Long.valueOf(12345L));
            this._receive(_TESTS_SPLIT_1, Long.valueOf(1L));
            this._receive(_TESTS_SPLIT_2, Long.valueOf(2L));
            this._somReceiver.commit();
        }
        finally {
            this.stopService(dataloggerService);
        }
        this._receive(_TESTS_STATE_1, Boolean.FALSE);
    }

    private void _receive(String pointName, Serializable expectedValue) throws Exception {
        Point point = (Point)this.getMetadata().getPoint(pointName).get();
        Serializable serializable = this._somReceiver.receive((long)this.getTimeout());
        Require.notNull((Object)serializable, (Object)("Expected: " + pointName));
        PointValue pointValue = (PointValue)serializable;
        Serializable receivedValue = pointValue.getValue();
        String receivedValueClass = receivedValue != null ? receivedValue.getClass().getSimpleName() : "null";
        Require.equal((Object)pointValue.getStamp(), (Object)DateTime.now());
        Require.equal(null, (Object)pointValue.getState());
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal((Object)receivedValue, (Object)expectedValue, (Object)(pointName + ": " + receivedValueClass));
    }
}

