/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.store.server.pap.cip;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.metadata.Metadata;
import org.rvpf.service.ServiceActivator;
import org.rvpf.store.server.pap.PAPStoreServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.store.StoreClientTests;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class StoreServerTests
extends StoreClientTests {
    private static final String _SERVICE_NAME = "CIP";
    private static final String _TESTS_BOOL_1_POINT = "TESTS-CIP.BOOL.1";
    private static final String _TESTS_DINT_1_POINT = "TESTS-CIP.DINT.1";
    private static final String _TESTS_DINT_ARRAY_1_POINT = "TESTS-CIP.DINT.ARRAY.1";
    private static final String _TESTS_INT_1_POINT = "TESTS-CIP.INT.1";
    private static final String _TESTS_PROPERTIES = "rvpf-cip.properties";
    private static final String _TESTS_REAL_1_POINT = "TESTS-CIP.REAL.1";
    private static final String _TESTS_REPLICATED_PROPERTY = "tests.replicated";
    private static final String _TESTS_REPLICATE_POINT = "TESTS.REPLICATE.01";
    private static final String _TESTS_SINT_1_POINT = "TESTS-CIP.SINT.1";
    private StoreSessionProxy _storeProxy;
    private ServiceActivator _storeService;

    @BeforeClass
    public void setUp() throws Exception {
        StoreServerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        StoreServerTests.setProperty((String)_TESTS_REPLICATED_PROPERTY, (String)"1");
        StoreServerTests.setProperty((String)"tests.cip.listen.port", (String)String.valueOf(StoreServerTests.allocateTCPPort()));
        this.setUpAlerter();
        Require.notNull((Object)this.getMetadata(true));
        this._storeService = this.createService(PAPStoreServiceActivator.class, Optional.of(_SERVICE_NAME));
        StoreServerTests.startService((ServiceActivator)this._storeService);
        this._storeProxy = this.getStoreProxy(this._storeService);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._storeProxy.tearDown();
        this.stopService(this._storeService);
        this._storeService = null;
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        Metadata metadata = this.getMetadata();
        MessagingSupport.Receiver replicateReceiver = this.getMessaging().createClientReceiver(metadata.getPropertiesGroup("tests.store.replicate.queue"));
        MessagingSupport.Receiver replicatedReceiver = this.getMessaging().createClientReceiver(metadata.getPropertiesGroup("tests.store.replicated.queue"));
        replicateReceiver.purge();
        replicatedReceiver.purge();
        this._sendPointValue(_TESTS_BOOL_1_POINT, Boolean.TRUE);
        Require.equal((Object)this._receivePointValue(_TESTS_BOOL_1_POINT), (Object)Boolean.TRUE);
        long timeout = this.getTimeout();
        Point replicatedPoint = (Point)metadata.getPointByName(_TESTS_BOOL_1_POINT).get();
        PointValue replicatedValue = (PointValue)replicatedReceiver.receive(timeout);
        Require.notNull((Object)replicatedValue);
        Require.equal((Object)replicatedValue.getPointUUID(), replicatedPoint.getUUID().get());
        Require.equal((Object)replicatedValue.getValue(), (Object)Boolean.TRUE);
        this._sendPointValue(_TESTS_SINT_1_POINT, Byte.valueOf((byte)43));
        Require.equal((Object)this._receivePointValue(_TESTS_SINT_1_POINT), (Object)43);
        this._sendPointValue(_TESTS_INT_1_POINT, Short.valueOf((short)432));
        Require.equal((Object)this._receivePointValue(_TESTS_INT_1_POINT), (Object)432);
        this._sendPointValue(_TESTS_DINT_1_POINT, Integer.valueOf(4321));
        Require.equal((Object)this._receivePointValue(_TESTS_DINT_1_POINT), (Object)4321);
        Point replicatePoint = (Point)metadata.getPointByName(_TESTS_REPLICATE_POINT).get();
        PointValue replicateValue = (PointValue)replicateReceiver.receive(timeout);
        Require.notNull((Object)replicateValue);
        Require.equal((Object)replicateValue.getPointUUID(), replicatePoint.getUUID().get());
        Require.equal((Object)replicateValue.getValue(), (Object)4321.0);
        Point arrayPoint = (Point)metadata.getPoint(_TESTS_DINT_ARRAY_1_POINT).get();
        Attributes attributes = (Attributes)arrayPoint.getAttributes(_SERVICE_NAME).get();
        int elements = attributes.getInt("ELEMENTS", 0);
        Tuple array = new Tuple(elements);
        for (int index = 0; index < elements; ++index) {
            array.add((Serializable)Integer.valueOf(index));
        }
        this._sendPointValue(_TESTS_DINT_ARRAY_1_POINT, (Serializable)array);
        Require.equal((Object)this._receivePointValue(_TESTS_DINT_ARRAY_1_POINT), (Object)array);
        this._sendPointValue(_TESTS_REAL_1_POINT, Float.valueOf(43.21f));
        Require.equal((Object)this._receivePointValue(_TESTS_REAL_1_POINT), (Object)Float.valueOf(43.21f));
        replicateReceiver.purge();
        replicateReceiver.close();
        replicatedReceiver.purge();
        replicatedReceiver.close();
    }

    private Serializable _receivePointValue(String pointKey) throws Exception {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        StoreValuesQuery.Builder storeQueryBuilder = StoreValuesQuery.newBuilder().setPoint(point);
        StoreValues storeValues = (StoreValues)this._storeProxy.select(storeQueryBuilder.build()).get();
        PointValue pointValue = (PointValue)storeValues.getPointValue().get();
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal(null, (Object)pointValue.getState());
        return (Serializable)Require.notNull((Object)pointValue.getValue());
    }

    private void _sendPointValue(String pointKey, Serializable value) throws Exception {
        PointValue pointValue = new PointValue(this.getPoint(pointKey), Optional.of(DateTime.now()), null, value);
        Require.success((boolean)this._storeProxy.updateAndCheck(pointValue, this.getThisLogger()));
    }
}

