/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.store.server.pap.dnp3;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.service.ServiceActivator;
import org.rvpf.store.server.pap.PAPStoreServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;
import org.rvpf.tests.store.StoreClientTests;
import org.rvpf.tests.store.server.pap.dnp3.StoreTarget;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class StoreServerTests
extends StoreClientTests {
    private static final String _ANALOG_INPUT_1 = "TESTS-DNP3.AI-SHORT-FLAGS.1";
    private static final String _ANALOG_OUTPUT_1 = "TESTS-DNP3.AO-SHORT.1";
    private static final String _SERVICE_NAME = "DNP3";
    private static final String _TESTS_PROPERTIES = "rvpf-dnp3.properties";
    private StoreSessionProxy _storeProxy;
    private ServiceActivator _storeService;
    private StoreTarget _target;

    @BeforeClass
    public void setUp() throws Exception {
        DNP3TestsSupport.setPortProperties();
        StoreServerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        this.setUpAlerter();
        this._target = new StoreTarget(this.getMetadata(true));
        this._target.start();
        this._storeService = this.createService(PAPStoreServiceActivator.class, Optional.of(_SERVICE_NAME));
        StoreServerTests.startService((ServiceActivator)this._storeService);
        this._storeProxy = this.getStoreProxy(this._storeService);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._target.stop();
        this._storeProxy.tearDown();
        this.stopService(this._storeService);
        this._storeService = null;
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        Metadata metadata = this.getMetadata();
        MessagingSupport.Receiver replicateReceiver = this.getMessaging().createClientReceiver(metadata.getPropertiesGroup("tests.store.replicate.queue"));
        MessagingSupport.Receiver replicatedReceiver = this.getMessaging().createClientReceiver(metadata.getPropertiesGroup("tests.store.replicated.queue"));
        replicateReceiver.purge();
        replicatedReceiver.purge();
        this._putPointValue(_ANALOG_INPUT_1, Short.valueOf((short)1234));
        Require.equal((Object)this._receivePointValue(_ANALOG_INPUT_1), (Object)1234);
        this._sendPointValue(_ANALOG_OUTPUT_1, Short.valueOf((short)4321));
        Require.equal((Object)this._receivePointValue(_ANALOG_OUTPUT_1), (Object)4321);
        Require.equal((Object)this._getPointValue(_ANALOG_OUTPUT_1), (Object)4321);
        replicateReceiver.purge();
        replicateReceiver.close();
        replicatedReceiver.purge();
        replicatedReceiver.close();
    }

    private Serializable _getPointValue(String pointKey) throws Exception {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        PointValue pointValue = this._target.getPointValue(point);
        Serializable value = pointValue.getValue();
        Require.notNull((Object)value);
        return value;
    }

    private void _putPointValue(String pointKey, Serializable value) {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        this._target.putPointValue(new PointValue(point, Optional.of(DateTime.now()), null, value));
    }

    private Serializable _receivePointValue(String pointKey) throws Exception {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        StoreValuesQuery.Builder storeQueryBuilder = StoreValuesQuery.newBuilder().setPoint(point);
        StoreValues storeValues = (StoreValues)this._storeProxy.select(storeQueryBuilder.build()).get();
        PointValue pointValue = (PointValue)storeValues.getPointValue().get();
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal(null, (Object)pointValue.getState());
        Serializable value = pointValue.getValue();
        Require.notNull((Object)value);
        return value;
    }

    private void _sendPointValue(String pointKey, Serializable value) throws Exception {
        PointValue pointValue = new PointValue(this.getPoint(pointKey), Optional.of(DateTime.now()), null, value);
        Require.success((boolean)this._storeProxy.updateAndCheck(pointValue, this.getThisLogger()));
    }
}

