/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.store.server.pap.dnp3;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.tests.pap.dnp3.DNP3TestsSupport;

final class StoreTarget
implements PAPProxy.Responder,
ServiceThread.Target {
    private static final Logger _LOGGER = Logger.getInstance(StoreTarget.class);
    private final Metadata _metadata;
    private DNP3Outstation _outstation;
    private Map<Point, PointValue> _pointValues = new ConcurrentHashMap<Point, PointValue>();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    StoreTarget(@Nonnull Metadata metadata) {
        this._metadata = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        while (true) {
            this.putPointValue((PointValue)this._outstation.nextUpdate(-1L).get());
            this._outstation.onUpdatesCommit();
            if (this._outstation.isUpdating()) continue;
            StoreTarget storeTarget = this;
            synchronized (storeTarget) {
                this.notifyAll();
            }
        }
    }

    public PointValue[] select(Point[] points) throws InterruptedException {
        PointValue[] pointValues = new PointValue[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointValues[i] = this._pointValues.get(points[i]);
        }
        return pointValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    PointValue getPointValue(@Nonnull Point point) throws InterruptedException {
        StoreTarget storeTarget = this;
        synchronized (storeTarget) {
            while (this._outstation.isUpdating()) {
                this.wait();
            }
        }
        return (PointValue)Require.notNull((Object)this._pointValues.get(point));
    }

    void putPointValue(@Nonnull PointValue pointValue) {
        Point point = (Point)pointValue.getPoint().get();
        this._pointValues.put(point, pointValue);
    }

    void start() {
        for (Point point : this._metadata.getPointsCollection()) {
            Require.success((boolean)((PointEntity)point).setUp(this._metadata));
        }
        DNP3TestsSupport support = new DNP3TestsSupport(Optional.of(this._metadata));
        this._outstation = support.getOutstation();
        this._outstation.setResponder((PAPProxy.Responder)this);
        this._outstation.setNeedTime();
        this._outstation.start();
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "DNP3 target");
        if (this._thread.compareAndSet(null, thread)) {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    void stop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            this._outstation.stop();
            Require.ignored((boolean)thread.interruptAndJoin(_LOGGER, 0L));
        }
    }
}

