/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tests.store.server.pap.modbus;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.service.ServiceActivator;
import org.rvpf.store.server.pap.PAPStoreServiceActivator;
import org.rvpf.tests.MessagingSupport;
import org.rvpf.tests.store.StoreClientTests;
import org.rvpf.tests.store.server.pap.modbus.StoreTarget;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public final class StoreServerTests
extends StoreClientTests {
    private static final String _POINT_COIL_1 = "TESTS-MODBUS.COIL.1";
    private static final String _POINT_DISCRETE_1 = "TESTS-MODBUS.DISCRETE.1";
    private static final String _POINT_INPUT_1 = "TESTS-MODBUS.INPUT.1";
    private static final String _POINT_REGISTER_1 = "TESTS-MODBUS.REGISTER.1";
    private static final String _POINT_REGISTER_2 = "TESTS-MODBUS.REGISTER.2";
    private static final String _REPLICATE_POINT_NAME = "TESTS.REPLICATE.01";
    private static final String _SERVICE_NAME = "Modbus";
    private static final String _TESTS_PROPERTIES = "rvpf-modbus.properties";
    private StoreSessionProxy _storeProxy;
    private ServiceActivator _storeService;
    private StoreTarget _target;

    @BeforeClass
    public void setUp() throws Exception {
        StoreServerTests.setSystemProperty((String)"rvpf.properties", (String)_TESTS_PROPERTIES);
        StoreServerTests.setProperty((String)"tests.modbus.listen.port", (String)String.valueOf(StoreServerTests.allocateTCPPort()));
        this.setUpAlerter();
        this._target = new StoreTarget(this.getMetadata(true));
        this._target.start();
        this._storeService = this.createService(PAPStoreServiceActivator.class, Optional.of(_SERVICE_NAME));
        StoreServerTests.startService((ServiceActivator)this._storeService);
        this._storeProxy = this.getStoreProxy(this._storeService);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this._target.stop();
        this._storeProxy.tearDown();
        this.stopService(this._storeService);
        this._storeService = null;
        this.tearDownAlerter();
    }

    @Test
    public void test() throws Exception {
        Metadata metadata = this.getMetadata();
        MessagingSupport.Receiver replicateReceiver = this.getMessaging().createClientReceiver(metadata.getPropertiesGroup("tests.store.replicate.queue"));
        MessagingSupport.Receiver replicatedReceiver = this.getMessaging().createClientReceiver(metadata.getPropertiesGroup("tests.store.replicated.queue"));
        replicateReceiver.purge();
        replicatedReceiver.purge();
        this._sendPointValue(_POINT_COIL_1, Boolean.TRUE);
        Require.equal((Object)this._getPointValue(_POINT_COIL_1), (Object)Boolean.TRUE);
        Require.equal((Object)this._receivePointValue(_POINT_COIL_1), (Object)Boolean.TRUE);
        this._putPointValue(_POINT_DISCRETE_1, Boolean.TRUE);
        Require.equal((Object)this._receivePointValue(_POINT_DISCRETE_1), (Object)Boolean.TRUE);
        this._putPointValue(_POINT_INPUT_1, Integer.valueOf(1234));
        Require.equal((Object)this._receivePointValue(_POINT_INPUT_1), (Object)1234);
        this._sendPointValue(_POINT_REGISTER_1, Integer.valueOf(4321));
        Require.equal((Object)this._getPointValue(_POINT_REGISTER_1), (Object)4321);
        Require.equal((Object)this._receivePointValue(_POINT_REGISTER_1), (Object)4321);
        this._sendPointValue(_POINT_REGISTER_2, Integer.valueOf(8765));
        Require.equal((Object)this._getPointValue(_POINT_REGISTER_2), (Object)8765);
        Require.equal((Object)this._receivePointValue(_POINT_REGISTER_2), (Object)8765);
        long timeout = this.getTimeout();
        Point replicatePoint = (Point)metadata.getPointByName(_REPLICATE_POINT_NAME).get();
        PointValue replicateValue = (PointValue)replicateReceiver.receive(timeout);
        Require.equal((Object)replicateValue.getPointUUID(), replicatePoint.getUUID().get());
        Require.equal((Object)replicateValue.getValue(), (Object)4321.0);
        Point replicatedPoint = (Point)metadata.getPointByName(_POINT_REGISTER_2).get();
        PointValue replicatedValue = (PointValue)replicatedReceiver.receive(timeout);
        Require.equal((Object)replicatedValue.getPointUUID(), replicatedPoint.getUUID().get());
        Require.equal((Object)replicatedValue.getValue(), (Object)8765L);
        replicateReceiver.purge();
        replicateReceiver.close();
        replicatedReceiver.purge();
        replicatedReceiver.close();
    }

    private Serializable _getPointValue(String pointKey) throws Exception {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        PointValue pointValue = this._target.getPointValue(point);
        Serializable value = pointValue.getValue();
        Require.notNull((Object)value);
        return value;
    }

    private void _putPointValue(String pointKey, Serializable value) {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        this._target.putPointValue(new PointValue(point, Optional.of(DateTime.now()), null, value));
    }

    private Serializable _receivePointValue(String pointKey) throws Exception {
        Point point = this.getPoint(pointKey);
        Require.notNull((Object)point);
        StoreValuesQuery.Builder storeQueryBuilder = StoreValuesQuery.newBuilder().setPoint(point);
        StoreValues storeValues = (StoreValues)this._storeProxy.select(storeQueryBuilder.build()).get();
        PointValue pointValue = (PointValue)storeValues.getPointValue().get();
        Require.equal((Object)pointValue.getPointUUID(), point.getUUID().get());
        Require.equal(null, (Object)pointValue.getState());
        Serializable value = pointValue.getValue();
        Require.notNull((Object)value);
        return value;
    }

    private void _sendPointValue(String pointKey, Serializable value) throws Exception {
        Point point = this.getPoint(pointKey);
        PointValue pointValue = new PointValue(point, Optional.of(DateTime.now()), null, value);
        Require.success((boolean)this._storeProxy.updateAndCheck(pointValue, this.getThisLogger()));
    }
}

